<?php
defined('BASEPATH') or exit('No direct script access allowed');

header('Content-Type: text/css');
header('Cache-Control: no-cache');

$CI =& get_instance();
if (!isset($CI->Settings_model)) {
    $CI->load->model('Settings_model');
}

$settings = $CI->Settings_model->get_settings();
if (!$settings) {
    echo "/* Default theme */\n";
    echo "body { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }\n";
    exit;
}

// Primary color variables
$primary_color = $settings->primary_color;
$secondary_color = $settings->secondary_color;
$text_color = $settings->text_color ?? '#000000';

// CSS variables
echo ":root {
    --primary-color: {$primary_color};
    --secondary-color: {$secondary_color};
    --text-color: {$text_color};
    --primary-hover: " . adjust_brightness($primary_color, -20) . ";
    --secondary-hover: " . adjust_brightness($secondary_color, -20) . ";
}";

// Background styles
switch ($settings->background_type) {
    case 'color':
        echo "body { background-color: {$settings->background_value}; }\n";
        break;
    case 'gradient':
        echo "body { background: {$settings->background_value}; }\n";
        break;
    case 'image':
        // Remove body background to prevent duplication
        echo "body { \n";
        echo "    background: transparent;\n";
        echo "    min-height: 100vh;\n";
        echo "    width: 100vw;\n";
        echo "    position: relative;\n";
        echo "    margin: 0;\n";
        echo "    padding: 0;\n";
        echo "}\n";
        
        // Create a dedicated background container
        echo ".background-container {\n";
        echo "    position: fixed;\n";
        echo "    top: 0;\n";
        echo "    left: 0;\n";
        echo "    width: 100vw;\n";
        echo "    height: 100vh;\n";
        echo "    z-index: -2;\n";
        echo "    overflow: hidden;\n";
        echo "}\n";
        
        echo ".background-container::before {\n";
        echo "    content: '';\n";
        echo "    position: absolute;\n";
        echo "    top: 0;\n";
        echo "    left: 0;\n";
        echo "    width: 100%;\n";
        echo "    height: 100%;\n";
        echo "    background-image: url(" . base_url('uploads/backgrounds/' . $settings->background_value) . ");\n";
        echo "    background-size: cover;\n";
        echo "    background-position: center;\n";
        echo "    background-repeat: no-repeat;\n";
        echo "    background-attachment: fixed;\n";
        echo "}\n";
        
        // Alternative fit modes for better control
        echo ".background-container.fit-contain::before {\n";
        echo "    background-size: contain;\n";
        echo "    background-position: center;\n";
        echo "}\n";
        
        echo ".background-container.fit-cover::before {\n";
        echo "    background-size: cover;\n";
        echo "    background-position: center;\n";
        echo "}\n";
        
        echo ".background-container.fit-fill::before {\n";
        echo "    background-size: 100% 100%;\n";
        echo "    background-position: center;\n";
        echo "}\n";
        
        // Responsive adjustments
        echo "@media (max-width: 768px) {\n";
        echo "    .background-container::before {\n";
        echo "        background-size: cover;\n";
        echo "        background-position: center center;\n";
        echo "    }\n";
        echo "}\n";
        
        echo "@media (min-width: 769px) and (max-width: 1024px) {\n";
        echo "    .background-container::before {\n";
        echo "        background-size: cover;\n";
        echo "        background-position: center center;\n";
        echo "    }\n";
        echo "}\n";
        
        echo "@media (min-width: 1025px) {\n";
        echo "    .background-container::before {\n";
        echo "        background-size: cover;\n";
        echo "        background-position: center center;\n";
        echo "    }\n";
        echo "}\n";
        
        // Add background overlay support
        if (!empty($settings->background_overlay)) {
            echo ".background-overlay {\n";
            echo "    position: fixed;\n";
            echo "    top: 0;\n";
            echo "    left: 0;\n";
            echo "    width: 100vw;\n";
            echo "    height: 100vh;\n";
            echo "    background: rgba(0, 0, 0, 0.3);\n";
            echo "    z-index: -1;\n";
            echo "}\n";
        }
        break;
}

// Tailwind CSS color overrides
echo ".bg-primary { background-color: var(--primary-color) !important; }\n";
echo ".bg-secondary { background-color: var(--secondary-color) !important; }\n";
echo ".text-primary { color: var(--primary-color) !important; }\n";
echo ".text-secondary { color: var(--secondary-color) !important; }\n";
echo ".text-default { color: var(--text-color) !important; }\n";
echo ".border-primary { border-color: var(--primary-color) !important; }\n";
echo ".border-secondary { border-color: var(--secondary-color) !important; }\n";
echo ".btn-primary { background-color: var(--primary-color) !important; border-color: var(--primary-color) !important; }\n";
echo ".btn-secondary { background-color: var(--secondary-color) !important; border-color: var(--secondary-color) !important; }\n";
echo ".btn-primary:hover { background-color: var(--primary-hover) !important; border-color: var(--primary-hover) !important; }\n";
echo ".btn-secondary:hover { background-color: var(--secondary-hover) !important; border-color: var(--secondary-hover) !important; }\n";

// Global text color
echo "body { color: var(--text-color); }\n";
echo "h1, h2, h3, h4, h5, h6 { color: var(--text-color); }\n";
echo "p, span, div { color: var(--text-color); }\n";
echo "a { color: var(--primary-color); }\n";
echo "a:hover { color: var(--primary-hover); }\n";

// Helper function
function adjust_brightness($hex, $steps)
{
    $steps = max(-255, min(255, $steps));
    $hex = str_replace('#', '', $hex);
    if (strlen($hex) == 3) {
        $hex = str_repeat(substr($hex, 0, 1), 2) . str_repeat(substr($hex, 1, 1), 2) . str_repeat(substr($hex, 2, 1), 2);
    }

    $color_parts = str_split($hex, 2);
    $return = '#';

    foreach ($color_parts as $color) {
        $color = hexdec($color);
        $color = max(0, min(255, $color + $steps));
        $return .= str_pad(dechex($color), 2, '0', STR_PAD_LEFT);
    }

    return $return;
}
?>

<?php
// Additional CSS for submenu transparency and hover effect
echo ".submenu-transparent {
    background-color: rgba(0, 0, 0, 0.3) !important;
    backdrop-filter: blur(8px);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.25);
}\n";

echo ".submenu-transparent a:hover {
    background-color: rgba(255, 255, 255, 0.1) !important;
}\n";
?>