<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <title>Add New Video</title>
    <link href="<?= base_url('assets/sbadmin2/css/sb-admin-2.min.css') ?>" rel="stylesheet" />
</head>

<body class="bg-gradient-primary">
    <div class="container">
        <div class="row justify-content-center mt-5">
            <div class="col-lg-6">
                <div class="card shadow-lg my-5">
                    <div class="card-body p-4">
                        <div class="text-center">
                            <h1 class="h4 text-gray-900 mb-4">Add New Video</h1>
                        </div>
                        <?php if (validation_errors()): ?>
                            <div class="alert alert-danger"><?= validation_errors() ?></div>
                        <?php endif; ?>
                        <form method="post" action="<?= site_url('admin/create') ?>">
                            <div class="form-group">
                                <label for="title">Title</label>
                                <input type="text" name="title" class="form-control" id="title" value="<?= set_value('title') ?>" required>
                            </div>
                            <div class="form-group">
                                <label for="embed_link">Embed Link</label>
                                <input type="text" name="embed_link" class="form-control" id="embed_link" value="<?= set_value('embed_link') ?>" required>
                            </div>
                            <button type="submit" class="btn btn-primary btn-block">Add Video</button>
                            <a href="<?= site_url('admin/manage_videos') ?>" class="btn btn-secondary btn-block">Cancel</a>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>

</html>
