<style>
    /* Perbaikan tampilan komentar agar username dan komentar berada di bawah avatar */
    .comment-block {
        display: flex;
        gap: 0.75rem;
        align-items: flex-start;
    }

    .comment-avatar {
        flex-shrink: 0;
        width: 40px;
        height: 40px;
        border-radius: 50%;
        background-color: #d1d5db;
        /* Tailwind gray-300 */
    }

    .comment-content-wrapper {
        display: flex;
        flex-direction: column;
    }

    .comment-user-info {
        display: flex;
        gap: 0.5rem;
        font-weight: 600;
        font-size: 0.875rem;
        color: #1f2937;
        /* Tailwind gray-900 */
    }

    .comment-date {
        font-weight: normal;
        font-size: 0.75rem;
        color: #6b7280;
        /* Tailwind gray-500 */
    }

    .comment-text {
        margin-top: 0.25rem;
        font-size: 0.875rem;
        color: #374151;
        /* Tailwind gray-700 */
        white-space: pre-wrap;
    }
</style>

<div class="card glass-card shadow-lg rounded-lg p-4">
    <div class="mb-6">
        <?php if (isset($video->video_type) && $video->video_type === 'live'): ?>
            <div class="mt-2 inline-block bg-red-600 text-white px-3 py-1 rounded-full text-sm font-semibold animate-pulse">
                LIVE STREAMING
            </div>
        <?php endif; ?>
    </div>

    <?php
    $this->load->helper('embed_helper');
    ?>
    <div class="bg-white dark:bg-gray-800 shadow-xl rounded-2xl overflow-hidden transition-all">
        <?php if ($video->source_type === 'link'): ?>
            <?php if (strpos($video->source, 'facebook.com') !== false): ?>
                <?php
                $video_url = $video->source;
                $is_group_or_share = (strpos($video_url, '/groups/') !== false) || (strpos($video_url, '/share/') !== false);
                ?>
                <?php if (!$is_group_or_share): ?>
                    <div id="fb-root"></div>
                    <script async defer crossorigin="anonymous"
                        src="https://connect.facebook.net/en_US/sdk.js#xfbml=1&version=v17.0" nonce="FbSdkNonce"></script>
                    <style>
                        .fb-video-container {
                            position: relative;
                            width: 100%;
                            max-width: 720px;
                            margin: 0 auto;
                            aspect-ratio: 16 / 9;
                            background: #000;
                        }

                        .loading-spinner {
                            position: absolute;
                            top: 50%;
                            left: 50%;
                            transform: translate(-50%, -50%);
                            border: 8px solid #f3f3f3;
                            border-top: 8px solid #3498db;
                            border-radius: 50%;
                            width: 60px;
                            height: 60px;
                            animation: spin 1s linear infinite;
                            z-index: 10;
                        }

                        @keyframes spin {
                            0% {
                                transform: translate(-50%, -50%) rotate(0deg);
                            }

                            100% {
                                transform: translate(-50%, -50%) rotate(360deg);
                            }
                        }

                        .fb-video iframe {
                            width: 100% !important;
                            height: 100% !important;
                            border: none !important;
                        }

                        .hidden {
                            display: none !important;
                        }
                    </style>
                    <div class="fb-video-container" role="region" aria-label="Facebook live video player">
                        <div class="loading-spinner" id="fbLoadingSpinner" aria-live="polite" aria-busy="true"></div>
                        <div class="fb-video" data-href="<?= htmlspecialchars($video_url) ?>" data-width="720"
                            data-show-text="false" data-lazy="true" style="height: 100%;">
                        </div>
                        <div id="fbFallbackMessage" class="hidden p-4 bg-yellow-100 text-yellow-800 rounded mt-4" role="alert"
                            aria-live="assertive">
                            <p>Video tidak dapat diputar di sini karena pembatasan konten. Silakan <a
                                    href="<?= htmlspecialchars($video_url) ?>" target="_blank" class="underline text-blue-600">klik
                                    di sini untuk menonton di Facebook</a>.</p>
                        </div>
                        <noscript>
                            <p>JavaScript is required to view the live video. Please enable JavaScript in your browser.</p>
                        </noscript>
                    </div>
                    <script>
                        document.addEventListener('DOMContentLoaded', function () {
                            var fbVideoContainer = document.querySelector('.fb-video-container');
                            var loadingSpinner = document.getElementById('fbLoadingSpinner');
                            var fallbackMessage = document.getElementById('fbFallbackMessage');
                            var iframe = fbVideoContainer.querySelector('iframe');

                            function hideSpinner() {
                                if (loadingSpinner) {
                                    loadingSpinner.classList.add('hidden');
                                }
                            }

                            function showFallback() {
                                if (fallbackMessage) {
                                    fallbackMessage.classList.remove('hidden');
                                }
                            }

                            // Poll for iframe load
                            var checkIframeLoaded = setInterval(function () {
                                if (iframe && iframe.contentDocument && iframe.contentDocument.readyState === 'complete') {
                                    hideSpinner();
                                    clearInterval(checkIframeLoaded);
                                }
                            }, 100);

                            // Timeout fallback to hide spinner and show fallback message after 10 seconds
                            setTimeout(function () {
                                hideSpinner();
                                showFallback();
                            }, 10000);
                        });
                    </script>
                <?php else: ?>
                    <p>Video ini berasal dari grup atau link share Facebook yang tidak dapat diputar langsung di sini. Silakan
                        klik tautan di bawah untuk menonton di Facebook.</p>
                    <a href="<?= htmlspecialchars($video_url) ?>" target="_blank"
                        class="text-blue-600 hover:underline break-all"><?= htmlspecialchars($video_url) ?></a>
                <?php endif; ?>
            <?php else: ?>
                <?= get_video_embed_html($video->source, 720, 405) ?>
            <?php endif; ?>
        <?php else: ?>
            <video controls class="w-full aspect-video bg-black rounded-none">
                <source src="<?= base_url($video->source) ?>" type="video/mp4" />
                Your browser does not support the video tag.
            </video>
        <?php endif; ?>
    </div>

    <!-- Judul Video -->
    <h2
        class="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white tracking-tight border-b border-gray-300 dark:border-gray-600 pb-3 mb-4">
        <?= htmlspecialchars($video->title) ?>
    </h2>

    <!-- Info & Deskripsi Video (Fade Transparan) -->
    <div
        class="mt-6 bg-white dark:bg-gray-800 rounded-lg p-4 shadow border border-gray-200 dark:border-gray-700 text-sm">
        <!-- Source URL -->
        <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-3">
            <div class="flex items-center gap-2">
                <span class="text-green-500 text-lg">🔗</span>
                <div>
                    <p class="font-medium text-gray-800 dark:text-gray-100">Source URL</p>
                    <?php if ($video->source_type === 'link'): ?>
                        <a href="<?= htmlspecialchars($video->source) ?>" class="text-blue-600 hover:underline break-all"
                            target="_blank">
                            <?= htmlspecialchars($video->source) ?>
                        </a>
                    <?php else: ?>
                        <a href="<?= base_url(htmlspecialchars($video->source)) ?>"
                            class="text-blue-600 hover:underline break-all" target="_blank">
                            <?= base_url(htmlspecialchars($video->source)) ?>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Deskripsi Video -->
        <div class="mt-4">
            <h3 class="text-base font-medium text-gray-800 dark:text-gray-100 mb-2">Description</h3>

            <div id="video-description"
                class="relative overflow-hidden max-h-20 transition-all duration-300 ease-in-out">
                <p class="text-sm text-gray-600 dark:text-gray-300 leading-relaxed">
                    <?= nl2br(htmlspecialchars($video->description)) ?>
                </p>
                <!-- Fade full transparan -->
                <div id="fade" class="absolute bottom-0 left-0 w-full h-8 bg-transparent pointer-events-none"></div>
            </div>

            <button id="toggle-description"
                class="mt-2 text-xs text-blue-500 hover:text-blue-600 dark:text-blue-400 dark:hover:text-blue-300 font-medium focus:outline-none">
                Show More
            </button>
        </div>
    </div>

    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const desc = document.getElementById("video-description");
            const btn = document.getElementById("toggle-description");
            const fade = document.getElementById("fade");

            let expanded = false;

            btn.addEventListener("click", function () {
                expanded = !expanded;
                desc.classList.toggle("max-h-20", !expanded);
                desc.classList.toggle("overflow-hidden", !expanded);
                fade.classList.toggle("hidden", expanded);
                btn.textContent = expanded ? "Show Less" : "Show More";
            });
        });
    </script>

    <!-- Comments Section -->
    <section class="mt-8">
        <h3 class="text-lg font-semibold mb-4 text-gray-900 dark:text-white">Comments</h3>

        <!-- Comment Form -->
        <form action="<?= site_url('user/post_comment') ?>" method="post" class="mb-6 flex space-x-3 items-start">
            <input type="hidden" name="video_id" value="<?= htmlspecialchars($video->id) ?>">

            <!-- Avatar Placeholder -->
            <div class="w-10 h-10 rounded-full bg-gray-300 flex-shrink-0"></div>

            <!-- Input -->
            <div class="flex-1">
                <input type="text" name="comment_text" required placeholder="Add a comment..."
                    class="w-full border-b border-gray-300 dark:border-gray-600 bg-transparent focus:outline-none focus:border-blue-500 px-1 py-2 text-sm text-gray-900 dark:text-white" />
                <div class="mt-2 flex space-x-2 justify-end">
                    <button type="submit"
                        class="px-4 py-1 text-sm rounded-full bg-blue-600 text-white hover:bg-blue-700 transition">
                        Comment
                    </button>
                </div>
            </div>
        </form>

        <!-- Existing Comments -->
        <div class="space-y-5">
            <?php if (!empty($comments)): ?>
                <?php foreach ($comments as $comment): ?>
                    <div class="comment-block">
                        <!-- Avatar -->
                        <div class="comment-avatar">
                            <?php if (!empty($comment->profile_photo)): ?>
                                <img src="<?= base_url('assets/sbadmin2/uploads/' . $comment->profile_photo) ?>"
                                    alt="<?= htmlspecialchars($comment->username) ?>"
                                    class="w-full h-full rounded-full object-cover">
                            <?php else: ?>
                                <svg class="w-full h-full rounded-full object-cover" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg" role="img" aria-label="Default user avatar">
                                    <circle cx="12" cy="12" r="10" fill="#d1d5db" />
                                    <path
                                        d="M12 12c1.656 0 3-1.344 3-3s-1.344-3-3-3-3 1.344-3 3 1.344 3 3 3zM12 14c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"
                                        fill="#9ca3af" />
                                </svg>
                            <?php endif; ?>
                        </div>

                        <!-- Comment Content Wrapper -->
                        <div class="comment-content-wrapper">
                            <div class="comment-user-info">
                                <p><?= htmlspecialchars($comment->username) ?></p>
                                <span class="comment-date"><?= date('M j, Y', strtotime($comment->created_at)) ?></span>
                            </div>
                            <div class="comment-text">
                                <?= nl2br(htmlspecialchars($comment->comment_text)) ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <p class="text-gray-600 dark:text-gray-400">No comments yet. Be the first to comment!</p>
            <?php endif; ?>
        </div>
    </section>

</div>
</div>