<div id="mainContent" class="container mx-auto py-8 px-4">
    <div class="flex items-center justify-between mb-8">
        <h1 class="text-3xl font-bold text-indigo-700">Upload Video</h1>
        <!-- Mobile sidebar toggle button -->
        <button id="mobileSidebarToggle" class="md:hidden text-indigo-700 text-3xl focus:outline-none"
            aria-label="Toggle sidebar">
            &#9776;
        </button>
    </div>

    <!-- Flash Messages -->
    <?php if ($this->session->flashdata('success')): ?>
        <div
            class="mb-6 flex items-center gap-2 text-sm font-medium text-green-800 bg-green-100 border border-green-300 px-4 py-3 rounded-lg shadow-sm">
            <i class="fas fa-check-circle"></i> <?= $this->session->flashdata('success'); ?>
        </div>
    <?php endif; ?>
    <?php if ($this->session->flashdata('error')): ?>
        <div
            class="mb-6 flex items-center gap-2 text-sm font-medium text-red-800 bg-red-100 border border-red-300 px-4 py-3 rounded-lg shadow-sm">
            <i class="fas fa-exclamation-circle"></i> <?= $this->session->flashdata('error'); ?>
        </div>
    <?php endif; ?>

    <!-- Card Form -->
    <div class="card glass-card shadow-lg rounded-lg p-4">
        <form method="POST" action="<?= site_url('upload-video'); ?>" enctype="multipart/form-data" class="space-y-5">

            <!-- Title -->
            <div>
                <label for="title" class="block text-gray-900 font-medium mb-2">Video Title</label>
                <input type="text" name="title" id="title" required value="<?= set_value('title') ?>"
                    class="w-full px-4 py-2 rounded-lg bg-white focus:ring-2 focus:ring-indigo-400 focus:outline-none" />
            </div>

            <!-- Description -->
            <div>
                <label for="description" class="block text-gray-900 font-medium mb-2">Description</label>
                <textarea name="description" id="description" rows="4" required
                    class="w-full px-4 py-2 rounded-lg bg-white focus:ring-2 focus:ring-indigo-400 focus:outline-none resize-none"><?= set_value('description') ?></textarea>
            </div>

            <!-- Video File Upload -->
            <div>
                <label for="video_file" class="block text-gray-900 font-medium mb-2">Upload Video File</label>
                <input type="file" name="video_file" id="video_file" accept="video/*"
                    class="block w-full text-sm file:mr-4 file:py-2 file:px-4 file:rounded-md file:border-0 file:text-sm file:font-semibold file:bg-indigo-600 file:text-white hover:file:bg-indigo-700 transition" />
            </div>

            <!-- Thumbnail Upload -->
            <div>
                <label for="thumbnail_file" class="block text-gray-900 font-medium mb-2">Upload Thumbnail Image</label>
                <input type="file" name="thumbnail_file" id="thumbnail_file" accept="image/*"
                    class="block w-full text-sm file:mr-4 file:py-2 file:px-4 file:rounded-md file:border-0 file:text-sm file:font-semibold file:bg-pink-500 file:text-white hover:file:bg-pink-600 transition" />
            </div>

            <!-- Video Link -->
            <div>
                <label for="link" class="block text-gray-900 font-medium mb-2">Or Video Link (URL)</label>
                <input type="url" name="link" id="link" value="<?= set_value('link') ?>"
                    class="w-full px-4 py-2 rounded-lg bg-white focus:ring-2 focus:ring-indigo-400 focus:outline-none" />
            </div>

            <!-- Submit & Cancel -->
            <div class="space-y-3">
                <button type="submit"
                    class="w-full bg-indigo-600 hover:bg-indigo-700 text-white font-semibold py-3 rounded-lg transition duration-200">
                    Upload Video
                </button>
                <a href="<?= site_url('myvideo') ?>"
                    class="block w-full text-center bg-gray-300 hover:bg-gray-400 text-gray-800 font-semibold py-3 rounded-lg transition duration-200">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</div>

<!-- Script JS -->
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const mobileToggleBtn = document.getElementById('mobileSidebarToggle');
        const sidebar = document.getElementById('accordionSidebar');

        if (mobileToggleBtn) {
            mobileToggleBtn.addEventListener('click', function () {
                sidebar.classList.toggle('expanded');
            });
        }
    });
</script>