<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>My Profile</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <style>
        /* Fullscreen modal styles */
        .profile-photo-modal {
            position: fixed;
            top: 0;
            left: 0;
            width: 100vw;
            height: 100vh;
            background: rgba(0, 0, 0, 0.8);
            backdrop-filter: blur(8px);
            display: flex;
            justify-content: center;
            align-items: center;
            opacity: 0;
            pointer-events: none;
            transition: opacity 0.3s ease;
            z-index: 2000;
        }

        .profile-photo-modal.active {
            opacity: 1;
            pointer-events: auto;
        }

        .profile-photo-modal-content {
            position: relative;
            max-width: 90vw;
            max-height: 90vh;
            animation: zoomIn 0.3s ease forwards;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.7);
        }

        .profile-photo-modal-content img {
            width: 100%;
            height: auto;
            display: block;
            border-radius: 12px;
            object-fit: contain;
        }

        .profile-photo-modal-close {
            position: absolute;
            top: 8px;
            right: 8px;
            background: rgba(0, 0, 0, 0.5);
            border: none;
            color: white;
            font-size: 1.5rem;
            padding: 4px 8px;
            border-radius: 6px;
            cursor: pointer;
            transition: background 0.3s ease;
            z-index: 10;
        }

        .profile-photo-modal-close:hover {
            background: rgba(0, 0, 0, 0.8);
        }

        @keyframes zoomIn {
            0% {
                transform: scale(0.7);
                opacity: 0;
            }

            100% {
                transform: scale(1);
                opacity: 1;
            }
        }

        @media (max-width: 600px) {
            .profile-photo-modal-content {
                max-width: 95vw;
                max-height: 80vh;
            }
        }
    </style>
</head>

<div id="mainContent" class="container mx-auto py-8 px-4">
    <div class="flex items-center justify-between mb-8">
        <h1 class="text-3xl font-bold text-indigo-700">Profile</h1>
        <!-- Mobile sidebar toggle button -->
        <button id="mobileSidebarToggle" class="md:hidden text-indigo-700 text-3xl focus:outline-none"
            aria-label="Toggle sidebar">
            &#9776;
        </button>
    </div>

    <?php if ($this->session->flashdata('success')): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            <?= $this->session->flashdata('success') ?>
        </div>
    <?php endif; ?>

    <?php if ($this->session->flashdata('error')): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
            <?= $this->session->flashdata('error') ?>
        </div>
    <?php endif; ?>

    <form action="<?= site_url('user/edit_profile') ?>" method="post" enctype="multipart/form-data"
        class="bg-white shadow-md rounded px-8 pt-6 pb-8 mb-4 w-full max-w-full mx-auto">
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <div class="flex flex-col items-center">
                <label class="block text-gray-700 text-sm font-bold mb-2" for="profile_photo">Profile
                    Photo</label>
                <div class="mb-2">
                    <?php
                    $theme_color = $this->session->userdata('theme_color') ?? '#0b3d0b';
                    ?>
                    <style>
                        .profile-photo-frame {
                            border-radius: 50%;
                            border: 3px solid
                                <?= $theme_color ?>
                            ;
                            box-shadow: 0 0 8px rgba(0, 0, 0, 0.3);
                            transition: transform 0.3s ease, box-shadow 0.3s ease;
                            width: 12rem;
                            /* 48 */
                            height: 12rem;
                            /* 48 */
                            object-fit: cover;
                        }

                        .profile-photo-frame:hover {
                            transform: scale(1.05);
                            box-shadow: 0 0 12px rgba(0, 0, 0, 0.5);
                        }
                    </style>
                    <?php
                    $theme_color = $this->session->userdata('theme_color') ?? '#0b3d0b';

                    // Define available frame styles
                    $frame_styles = [
                        'green' => 'border: 3px solid #0b3d0b; box-shadow: 0 0 8px rgba(0, 0, 0, 0.3);',
                        'blue' => 'border: 3px solid #004080; box-shadow: 0 0 8px rgba(0, 0, 128, 0.3);',
                        'red' => 'border: 3px solid #800000; box-shadow: 0 0 8px rgba(128, 0, 0, 0.3);',
                        'dashed' => 'border: 3px dashed #0b3d0b; box-shadow: 0 0 8px rgba(0, 0, 0, 0.3);',
                        'shadow' => 'border: none; box-shadow: 0 0 12px rgba(0, 0, 0, 0.5);',
                        'glow' => 'border: 3px solid #39ff14; box-shadow: 0 0 10px #39ff14, 0 0 20px #39ff14, 0 0 30px #39ff14;',
                        'gradient' => 'border: 3px solid; border-image-slice: 1; border-width: 3px; border-image-source: linear-gradient(45deg, #f3ec78, #af4261); box-shadow: 0 0 8px rgba(175, 66, 97, 0.5);',
                        'futuristic' => 'border: 3px solid #00ffff; box-shadow: 0 0 8px #00ffff, 0 0 15px #00ffff, 0 0 20px #00ffff;',
                        'classic' => 'border: 3px solid #000000; box-shadow: none;',
                        'neon' => 'border: 3px solid #ff00ff; box-shadow: 0 0 5px #ff00ff, 0 0 10px #ff00ff, 0 0 20px #ff00ff;',
                        'fire' => 'border: 3px solid #ff4500; box-shadow: 0 0 5px #ff4500, 0 0 10px #ff6347, 0 0 15px #ff7f50, 0 0 20px #ff4500;',
                    ];

                    $selected_frame_style = $user->profile_frame_style ?? 'green';
                    $selected_style_css = $frame_styles[$selected_frame_style] ?? $frame_styles['green'];
                    ?>
                    <style>
                        .profile-photo-frame {
                            border-radius: 50%;
                            transition: transform 0.3s ease, box-shadow 0.3s ease;
                            width: 12rem;
                            /* 48 */
                            height: 12rem;
                            /* 48 */
                            object-fit: cover;
                        }

                        .profile-photo-frame:hover {
                            transform: scale(1.05);
                            box-shadow: 0 0 12px rgba(0, 0, 0, 0.5);
                        }
                    </style>
                    <img src="<?= base_url('assets/sbadmin2/uploads/' . ($user->profile_photo ?? 'default-profile.png')) ?>"
                        alt="Profile Photo" class="profile-photo-frame" style="<?= $selected_style_css ?>"
                        id="profilePagePhoto">
                </div>
                <label class="block text-gray-700 text-sm font-bold mb-2 mt-4" for="profile_frame_style">Pilih
                    Bingkai Profil</label>
                <select name="profile_frame_style" id="profile_frame_style"
                    class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                    <?php foreach ($frame_styles as $key => $style): ?>
                        <option value="<?= $key ?>" <?= $selected_frame_style === $key ? 'selected' : '' ?>>
                            <?= ucfirst($key) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <input type="file" name="profile_photo" id="profile_photo" accept="image/*"
                class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded file:border-0 file:text-sm file:font-semibold file:bg-green-50 file:text-green-700 hover:file:bg-green-100" />
            <?php echo form_error('profile_photo', '<p class="text-red-500 text-xs italic mt-1">', '</p>'); ?>
        </div>

        <div class="md:col-span-2">
            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2" for="name">Name</label>
                <input type="text" name="name" id="name" value="<?= set_value('name', $user->name ?? '') ?>" required
                    class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" />
                <?php echo form_error('name', '<p class="text-red-500 text-xs italic mt-1">', '</p>'); ?>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2" for="email">Email</label>
                <input type="email" name="email" id="email" value="<?= set_value('email', $user->email ?? '') ?>"
                    required
                    class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" />
                <?php echo form_error('email', '<p class="text-red-500 text-xs italic mt-1">', '</p>'); ?>
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 text-sm font-bold mb-2" for="password">New Password (leave
                    blank to keep current)</label>
                <input type="password" name="password" id="password"
                    class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" />
                <?php echo form_error('password', '<p class="text-red-500 text-xs italic mt-1">', '</p>'); ?>
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 text-sm font-bold mb-2" for="self_description">Deskripsikan
                    Diri Anda</label>
                <textarea name="self_description" id="self_description" rows="4"
                    class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline"><?= set_value('self_description', $user->self_description ?? '') ?></textarea>
            </div>

            <div class="flex items-center justify-between">
                <button type="submit"
                    class="btn-secondary font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline">
                    Save Changes
                </button>

                <button type="button" id="deleteAccountBtn"
                    class="btn-secondary font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline">
                    Delete Account
                </button>
            </div>
        </div>
</div>
</form>
</main>

<!-- Delete Account Confirmation Modal -->
<div id="deleteModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden">
    <div class="bg-white rounded-lg shadow-lg p-6 max-w-sm w-full">
        <h2 class="text-xl font-bold mb-4">Confirm Account Deletion</h2>
        <p class="mb-4">Are you sure you want to delete your account? This action cannot be undone.</p>
        <div class="flex justify-end space-x-4">
            <button id="cancelDeleteBtn" class="px-4 py-2 bg-gray-300 rounded hover:bg-gray-400">Cancel</button>
            <form action="<?= site_url('user/delete_account') ?>" method="post" class="inline">
                <button type="submit" class="px-4 py-2 bg-red-600 text-white rounded hover:bg-red-700">Delete</button>
            </form>
        </div>
    </div>
</div>

<script>
    document.getElementById('deleteAccountBtn').addEventListener('click', function () {
        document.getElementById('deleteModal').classList.remove('hidden');
    });

    document.getElementById('cancelDeleteBtn').addEventListener('click', function () {
        document.getElementById('deleteModal').classList.add('hidden');
    });
</script>

<!-- Fullscreen Profile Photo Modal -->
<div id="profilePagePhotoModal" class="profile-photo-modal" aria-hidden="true" role="dialog" aria-modal="true">
    <div class="profile-photo-modal-content" role="document">
        <button class="profile-photo-modal-close" aria-label="Close">&times;</button>
        <img src="" alt="Profile Photo Fullscreen" id="profilePagePhotoModalImg">
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const profilePhoto = document.getElementById('profilePagePhoto');
        const modal = document.getElementById('profilePagePhotoModal');
        const modalImg = document.getElementById('profilePagePhotoModalImg');
        const closeBtn = modal.querySelector('.profile-photo-modal-close');

        if (profilePhoto && modal && modalImg && closeBtn) {
            profilePhoto.addEventListener('click', function () {
                modalImg.src = this.src;
                modal.classList.add('active');
                modal.setAttribute('aria-hidden', 'false');
            });

            closeBtn.addEventListener('click', function () {
                modal.classList.remove('active');
                modal.setAttribute('aria-hidden', 'true');
                modalImg.src = '';
            });

            modal.addEventListener('click', function (e) {
                if (e.target === modal) {
                    modal.classList.remove('active');
                    modal.setAttribute('aria-hidden', 'true');
                    modalImg.src = '';
                }
            });
        }
    });
</script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const mobileToggleBtn = document.getElementById('mobileSidebarToggle');
        const sidebar = document.getElementById('accordionSidebar');

        if (mobileToggleBtn) {
            mobileToggleBtn.addEventListener('click', function () {
                sidebar.classList.toggle('expanded');
            });
        }
    });
</script>
</body>

</html>