<div id="mainContent" class="container mx-auto py-8 px-4">
    <div class="flex items-center justify-between mb-8">
        <h1 class="text-3xl font-bold text-indigo-700">My Video</h1>
        <!-- Mobile sidebar toggle button -->
        <button id="mobileSidebarToggle" class="md:hidden text-indigo-700 text-3xl focus:outline-none"
            aria-label="Toggle sidebar">
            &#9776;
        </button>
    </div>

    <?php if (!empty($videos)): ?>
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
            <?php foreach ($videos as $video): ?>
                <div class="bg-white dark:bg-gray-800 shadow rounded-lg overflow-hidden">
                    <?php if ($video->source_type === 'file'): ?>
                        <video class="w-full h-48 object-cover" controls>
                            <source src="<?= base_url($video->source); ?>" type="video/mp4">
                            Your browser does not support the video tag.
                        </video>
                    <?php elseif ($video->source_type === 'link'): ?>
                        <div class="relative w-full h-48">
                            <?php
                            $this->load->helper('embed_helper');
                            if (strpos($video->source, 'drive.google.com') !== false || strpos($video->source, 'LiveStreaming.aspx') !== false) {
                                echo get_video_embed_html($video->source, 320, 180);
                            } else {
                                // For other links (Facebook, YouTube, etc.), keep existing iframe embed
                                ?>
                                <iframe class="w-full h-full" src="<?= htmlspecialchars($video->source); ?>" allowfullscreen></iframe>
                                <?php
                            }
                            ?>
                        </div>
                    <?php endif; ?>

                    <div class="p-4">
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-white truncate">
                            <?= htmlspecialchars($video->title ?? 'Untitled') ?>
                        </h3>
                        <p class="text-sm text-gray-600 dark:text-gray-300 mt-2 line-clamp-3">
                            <?= htmlspecialchars($video->description ?? '-') ?>
                        </p>
                        <a href="<?= site_url('watch-video/' . $video->id); ?>"
                            class="mt-4 inline-block btn-secondary px-4 py-2 rounded hover:bg-secondary transition">
                            Watch
                        </a>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php else: ?>
        <p class="text-gray-500 dark:text-gray-400">You have not uploaded any videos yet.</p>
    <?php endif; ?>
</div>

<!-- Script JS -->
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const mobileToggleBtn = document.getElementById('mobileSidebarToggle');
        const sidebar = document.getElementById('accordionSidebar');

        if (mobileToggleBtn) {
            mobileToggleBtn.addEventListener('click', function () {
                sidebar.classList.toggle('expanded');
            });
        }
    });
</script>