<!DOCTYPE html>
<html lang="en" class="scroll-smooth">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Mobile Video Player</title>
    <style>
        body {
            margin: 0;
            background-color: #000;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            color: white;
            font-family: Arial, sans-serif;
        }
        .video-container {
            width: 100%;
            max-width: 480px;
            position: relative;
            background-color: #000;
        }
        video, iframe {
            width: 100%;
            height: auto;
            border: none;
            border-radius: 8px;
        }
        .play-button {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            font-size: 4rem;
            color: white;
            cursor: pointer;
            opacity: 0.8;
        }
    </style>
</head>
<body>

<div class="video-container" id="videoContainer">
    <?php if ($video->source_type === 'link' && strpos($video->source, 'facebook.com') !== false): ?>
        <?php $encoded_url = urlencode($video->source); ?>
        <iframe src="https://www.facebook.com/plugins/video.php?href=<?= $encoded_url ?>&show_text=0&width=480"
            allowfullscreen allow="autoplay; clipboard-write; encrypted-media; picture-in-picture; web-share" id="videoIframe"></iframe>
    <?php elseif ($video->source_type === 'link'): ?>
        <?= get_video_embed_html($video->source, 480, 270) ?>
    <?php else: ?>
        <video controls autoplay muted playsinline>
            <source src="<?= base_url($video->source) ?>" type="video/mp4" />
            Your browser does not support the video tag.
        </video>
    <?php endif; ?>
</div>

</body>
</html>
