<!DOCTYPE html>
<html lang="en" class="scroll-smooth">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Mobile Friendly Video View</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@3.3.2/dist/tailwind.min.css" rel="stylesheet" />
</head>
<body class="bg-gray-100 dark:bg-gray-900 text-gray-900 dark:text-gray-100">

<main class="max-w-md mx-auto p-4">
    <h1 class="text-2xl font-bold mb-4"><?= htmlspecialchars($video->title) ?></h1>

    <style>
        .video-preview-container {
            position: relative;
            cursor: pointer;
        }
        .video-preview-overlay {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.4);
            display: flex;
            justify-content: center;
            align-items: center;
            color: white;
            font-size: 3rem;
            transition: background 0.3s ease;
        }
        .video-preview-overlay:hover {
            background: rgba(0,0,0,0.6);
        }
        .hidden {
            display: none !important;
        }
    </style>

    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md overflow-hidden mb-4">
        <?php if ($video->source_type === 'link'): ?>
            <?php if (strpos($video->source, 'facebook.com') !== false): ?>
                <?php
                $video_url = $video->source;
                $is_group_or_share = (strpos($video_url, '/groups/') !== false) || (strpos($video_url, '/share/') !== false);
                ?>
                <?php if (!$is_group_or_share): ?>
                    <?php $encoded_url = urlencode($video_url); ?>
                    <?php
                    // Detect mobile user agent
                    $is_mobile = preg_match('/(android|iphone|ipad|mobile)/i', $_SERVER['HTTP_USER_AGENT']);
                    ?>
                    <?php if ($is_mobile): ?>
                        <!-- On mobile, directly show iframe without preview overlay for better UX -->
                        <div class="relative w-full" style="padding-top: 56.25%;">
                            <iframe src="https://www.facebook.com/plugins/video.php?href=<?= $encoded_url ?>&show_text=0&width=720"
                                class="absolute top-0 left-0 w-full h-full border-0" allowfullscreen allow="autoplay; clipboard-write; encrypted-media; picture-in-picture; web-share" id="videoIframe"></iframe>
                        </div>
                    <?php else: ?>
                        <div class="aspect-video video-preview-container" id="videoPreviewContainer">
                            <img src="<?= base_url('uploads/videos/preview.jpg') ?>" alt="Video Preview" class="w-full h-full object-cover" id="videoPreviewImage" />
                            <div class="video-preview-overlay" id="videoPlayButton">&#9658;</div>
                            <iframe src="https://www.facebook.com/plugins/video.php?href=<?= $encoded_url ?>&show_text=0&width=720"
                                class="w-full h-full border-0 hidden" allowfullscreen allow="autoplay; clipboard-write; encrypted-media; picture-in-picture; web-share" id="videoIframe"></iframe>
                        </div>
                    <?php endif; ?>
                <?php else: ?>
                    <p class="p-4 text-center text-red-600">Video ini berasal dari grup atau link share Facebook yang tidak dapat diputar langsung di sini. Silakan klik tautan di bawah untuk menonton di Facebook.</p>
                    <a href="<?= htmlspecialchars($video_url) ?>" target="_blank" class="block text-center text-blue-600 hover:underline mb-4"><?= htmlspecialchars($video_url) ?></a>
                <?php endif; ?>
            <?php else: ?>
                <div class="aspect-video video-preview-container" id="videoPreviewContainer">
                    <img src="<?= base_url('uploads/videos/preview.jpg') ?>" alt="Video Preview" class="w-full h-full object-cover" id="videoPreviewImage" />
                    <div class="video-preview-overlay" id="videoPlayButton">&#9658;</div>
                    <div id="videoEmbedContainer" class="hidden">
                        <?= get_video_embed_html($video->source, 720, 405) ?>
                    </div>
                </div>
            <?php endif; ?>
        <?php else: ?>
            <div class="relative w-full" style="padding-top: 56.25%;">
                <video controls class="absolute top-0 left-0 w-full h-full bg-black rounded-md hidden" id="videoPlayer">
                    <source src="<?= base_url($video->source) ?>" type="video/mp4" />
                    Your browser does not support the video tag.
                </video>
        <?php endif; ?>
    </div>

    <section class="mb-6">
        <h2 class="text-lg font-semibold mb-2">Description</h2>
        <p class="whitespace-pre-wrap text-gray-700 dark:text-gray-300"><?= nl2br(htmlspecialchars($video->description)) ?></p>
    </section>

    <section>
        <h2 class="text-lg font-semibold mb-4">Comments</h2>

        <form id="commentForm" action="<?= site_url('user/post_comment') ?>" method="post" class="mb-4 space-y-2">
            <input type="hidden" name="video_id" value="<?= htmlspecialchars($video->id) ?>" />
            <input type="text" name="comment_text" id="commentText" required placeholder="Add a comment..."
                class="w-full border border-gray-300 rounded px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:text-gray-100" />
            <button type="submit" class="w-full bg-blue-600 text-white py-2 rounded hover:bg-blue-700 transition">Comment</button>
        </form>

        <div class="space-y-4 max-h-64 overflow-y-auto" id="commentsContainer">
            <?php if (!empty($comments)): ?>
                <?php foreach ($comments as $comment): ?>
                    <div class="bg-gray-200 dark:bg-gray-700 rounded p-3">
                        <p class="font-semibold text-gray-900 dark:text-gray-100"><?= htmlspecialchars($comment->username) ?></p>
                        <p class="text-gray-800 dark:text-gray-300 mt-1 whitespace-pre-wrap"><?= nl2br(htmlspecialchars($comment->comment_text)) ?></p>
                        <p class="text-xs text-gray-500 dark:text-gray-400 mt-2"><?= date('F j, Y, g:i a', strtotime($comment->created_at)) ?></p>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <p class="text-center text-gray-600 dark:text-gray-400">No comments yet. Be the first to comment!</p>
            <?php endif; ?>
        </div>
    </section>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const previewContainer = document.getElementById('videoPreviewContainer');
            const playButton = document.getElementById('videoPlayButton');
            const previewImage = document.getElementById('videoPreviewImage');
            const iframe = document.getElementById('videoIframe');
            const videoPlayer = document.getElementById('videoPlayer');
            const videoEmbedContainer = document.getElementById('videoEmbedContainer');

            function showVideo() {
                previewImage.classList.add('hidden');
                playButton.classList.add('hidden');
                if (iframe) {
                    iframe.classList.remove('hidden');
                }
                if (videoPlayer) {
                    videoPlayer.classList.remove('hidden');
                    videoPlayer.play();
                }
                if (videoEmbedContainer) {
                    videoEmbedContainer.classList.remove('hidden');
                }
            }

            if (previewContainer && playButton) {
                previewContainer.addEventListener('click', showVideo);
                playButton.addEventListener('click', showVideo);
            }
        });
    </script>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const commentForm = document.getElementById('commentForm');
        const commentText = document.getElementById('commentText');
        let commentsContainer = document.getElementById('commentsContainer');

        if (!commentForm) {
            console.error('Comment form not found');
            return;
        }

        commentForm.addEventListener('submit', function(e) {
            e.preventDefault();

            const formData = new FormData(commentForm);

            fetch(commentForm.action, {
                method: 'POST',
                body: formData,
                headers: {
                    'X-Requested-With': 'XMLHttpRequest'
                }
            })
            .then(response => {
                if (!response.ok) {
                    throw new Error('Network response was not ok');
                }
                return response.json();
            })
            .then(data => {
                if (data.success) {
                    const newComment = document.createElement('div');
                    newComment.className = 'bg-gray-200 dark:bg-gray-700 rounded p-3';
                    newComment.innerHTML = `
                        <p class="font-semibold text-gray-900 dark:text-gray-100">${data.comment.username}</p>
                        <p class="text-gray-800 dark:text-gray-300 mt-1 whitespace-pre-wrap">${data.comment.comment_text}</p>
                        <p class="text-xs text-gray-500 dark:text-gray-400 mt-2">${data.comment.created_at}</p>
                    `;
                    if (commentsContainer) {
                        commentsContainer.prepend(newComment);
                    }
                    commentText.value = '';
                } else {
                    alert('Failed to post comment: ' + (data.error || 'Unknown error'));
                }
            })
            .catch(err => {
                alert('Error posting comment: ' + err.message);
            });
        });
    });
    </script>
</body>
</html>
