<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<div id="mainContent" class="container mx-auto py-8 px-4">
    <div class="flex items-center justify-between mb-8">
        <h1 class="text-3xl font-bold text-indigo-700">Live</h1>
        <!-- Mobile sidebar toggle button -->
        <button id="mobileSidebarToggle" class="md:hidden text-indigo-700 text-3xl focus:outline-none"
            aria-label="Toggle sidebar">
            &#9776;
        </button>
    </div>

    <?php if (!empty($live_streams)): ?>
        <div class="row">
            <?php foreach ($live_streams as $stream): ?>
                <div class="col-md-4 mb-3">
                    <div class="card">
                        <?php if (!empty($stream->thumbnail)): ?>
                            <img src="<?php echo base_url($stream->thumbnail); ?>" class="card-img-top"
                                alt="<?php echo htmlspecialchars($stream->title); ?>" style="height: 200px; object-fit: cover;">
                        <?php else: ?>
                            <img src="<?php echo base_url('assets/default-thumbnail.jpg'); ?>" class="card-img-top"
                                alt="<?php echo htmlspecialchars($stream->title); ?>" style="height: 200px; object-fit: cover;">
                        <?php endif; ?>
                        <div class="card-body">
                            <h5 class="card-title"><?php echo htmlspecialchars($stream->title); ?></h5>
                            <p class="card-text">
                                <?php if (strlen($stream->description ?? '') > 100): ?>
                                    <?php echo htmlspecialchars(substr($stream->description ?? '', 0, 100)) . '...'; ?>
                                <?php else: ?>
                                    <?php echo htmlspecialchars($stream->description ?? 'No description'); ?>
                                <?php endif; ?>
                            </p>
                            <p class="card-text"><small class="text-muted">Streamer:
                                    <?php echo htmlspecialchars($stream->streamer_name ?? $stream->username ?? 'Unknown'); ?></small>
                            </p>
                            <?php if (!empty($stream->source)): ?>
                                <a href="<?php echo site_url('user/watch_video/' . $stream->id); ?>" class="btn btn-primary">Watch
                                    Live</a>
                            <?php else: ?>
                                <p><em>Stream URL not available</em></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php else: ?>
        <p>No live streams available at the moment.</p>
    <?php endif; ?>
</div>

<!-- Script JS -->
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const mobileToggleBtn = document.getElementById('mobileSidebarToggle');
        const sidebar = document.getElementById('accordionSidebar');

        if (mobileToggleBtn) {
            mobileToggleBtn.addEventListener('click', function () {
                sidebar.classList.toggle('expanded');
            });
        }
    });
</script>