<body class="min-h-screen flex flex-col bg-gradient-to-r from-blue-500 via-indigo-500 to-purple-500">

    <!-- Main Content -->
    <div id="mainContent" class="flex-grow container mx-auto py-8 px-4 flex flex-col justify-center">

        <!-- Header -->
        <div class="text-center mb-8">
            <h1 class="text-3xl font-bold text-white">Lupa Password</h1>
        </div>

        <!-- Box Form -->
        <div class="w-full max-w-md mx-auto bg-white rounded-2xl shadow-md p-5 sm:p-6 animate-fadeIn">

            <!-- Header -->
            <div class="text-center mb-4">
                <h2 class="text-2xl font-bold text-green-700">Lupa Password</h2>
                <p class="text-sm text-gray-500 mt-1">
                    Masukkan email Anda untuk reset password
                </p>
            </div>

            <!-- Alert Success -->
            <?php if ($this->session->flashdata('success')): ?>
                <div class="p-3 text-green-700 bg-green-100 border border-green-300 rounded-md text-sm mb-4">
                    <?= $this->session->flashdata('success') ?>
                </div>
            <?php endif; ?>

            <!-- Alert Error -->
            <?php if ($this->session->flashdata('error')): ?>
                <div class="p-3 text-red-700 bg-red-100 border border-red-300 rounded-md text-sm mb-4">
                    <?= $this->session->flashdata('error') ?>
                </div>
            <?php endif; ?>

            <!-- Form -->
            <form method="post" action="<?= site_url('user/forgot_password') ?>" class="space-y-5">

                <!-- Email -->
                <div>
                    <label for="email" class="block text-gray-700 text-sm mb-1">Email Anda</label>
                    <input type="email" id="email" name="email" required
                        class="w-full px-4 py-2 rounded-lg border border-gray-300 bg-gray-50 text-gray-700 text-base focus:outline-none focus:ring-2 focus:ring-green-400 transition">
                    <?= form_error('email', '<small class="text-red-600">', '</small>'); ?>
                </div>

                <!-- Submit Button -->
                <button type="submit"
                    class="w-full py-2.5 bg-green-600 hover:bg-green-700 text-white text-base font-medium rounded-lg shadow transition duration-300">
                    Kirim Email Reset
                </button>
            </form>

            <!-- Back Link -->
            <div class="text-center mt-4">
                <a href="<?= site_url('login') ?>" class="text-green-600 hover:underline text-sm">
                    Kembali ke Dashboard
                </a>
            </div>
        </div>
    </div>

    <!-- Animasi -->
    <style>
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(10px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .animate-fadeIn {
            animation: fadeIn 0.4s ease-out;
        }
    </style>
</body>