<!-- Ganti background dengan linear gradient -->
<div id="mainContent" class="w-full py-8 px-4 min-h-screen">
    <div class="flex items-center justify-between mb-8">
        <h1 class="text-3xl font-bold text-white drop-shadow">Welcome Back</h1>
        <!-- Mobile sidebar toggle button -->
        <button id="mobileSidebarToggle" class="md:hidden text-white text-3xl focus:outline-none"
            aria-label="Toggle sidebar">
            &#9776;
        </button>
    </div>

    <!-- Your Uploaded Videos -->
    <section class="mb-10">
        <div
            class="bg-white/80 dark:bg-gray-900/80 backdrop-blur-md border border-gray-200 dark:border-gray-700 shadow-2xl rounded-3xl overflow-hidden transition-all duration-300">
            <div
                class="flex justify-between items-center bg-gradient-to-r from-indigo-600 to-purple-600 px-6 py-4 text-white text-lg font-bold rounded-t-3xl shadow-md">
                <div class="flex items-center gap-2">
                    <i class="fas fa-cloud-upload-alt animate-pulse"></i>
                    <span>Video yang Kamu Upload</span>
                </div>
                <span class="bg-secondary text-secondary px-3 py-1 rounded-full text-sm font-semibold shadow-sm">
                    <?= count($videos) ?> video
                </span>
            </div>

            <div class="p-6">
                <?php if (!empty($videos)): ?>
                    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6">
                        <?php foreach ($videos as $video): ?>
                            <a href="<?= site_url('watch-video/' . $video->id) ?>"
                                class="group block bg-white dark:bg-gray-800 rounded-2xl shadow-lg border border-gray-200 dark:border-gray-700 overflow-hidden hover:shadow-2xl hover:-translate-y-1 transition-all duration-300">
                                <div class="overflow-hidden relative">
                                    <img src="<?= !empty($video->thumbnail) ? base_url($video->thumbnail) : base_url('assets/sbadmin2/img/video-placeholder.png') ?>"
                                        alt="Thumbnail"
                                        class="w-full h-48 object-cover group-hover:scale-110 transition-transform duration-500" />
                                    <div class="absolute bottom-2 right-2 bg-black/60 text-white text-xs px-2 py-1 rounded">
                                        <i class="fas fa-play-circle mr-1"></i> Tonton
                                    </div>
                                </div>
                                <div class="p-4">
                                    <h3 class="text-md font-semibold text-gray-900 dark:text-white truncate">
                                        <?= htmlspecialchars($video->title) ?>
                                    </h3>
                                    <p class="text-sm text-gray-600 dark:text-gray-300 mt-1">
                                        <?= word_limiter(strip_tags($video->description), 10) ?>
                                    </p>
                                    <span class="block text-xs text-gray-500 dark:text-gray-400 mt-3">
                                        <i class="far fa-clock mr-1"></i>
                                        <?= date('M d, Y', strtotime($video->created_at)) ?>
                                    </span>
                                </div>
                            </a>
                        <?php endforeach; ?>
                    </div>
                <?php else: ?>
                    <div class="text-center text-gray-600 dark:text-gray-300 text-sm py-10">
                        <i class="fas fa-video-slash text-3xl mb-2 text-gray-400"></i>
                        <p>Belum ada video yang diunggah. Yuk mulai upload sekarang!</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <!-- Live Videos -->
    <section class="my-10">
        <div
            class="bg-white dark:bg-gray-900 rounded-2xl shadow-xl border border-green-600 dark:border-green-700 overflow-hidden">

            <!-- HEADER -->
            <div
                class="bg-gradient-to-r from-green-600 to-green-500 text-white px-6 py-4 flex justify-between items-center">
                <div class="flex items-center gap-3 text-lg font-bold">
                    <i class="fas fa-satellite-dish text-xl"></i>
                    <span>Live Streaming</span>
                </div>
                <span class="bg-secondary text-secondary font-semibold px-4 py-1 rounded-full text-sm shadow">
                    <?= count(array_filter($admin_videos, function ($video) {
                        return isset($video->video_type) && $video->video_type === 'live';
                    })) ?>
                    Live
                </span>
            </div>

            <!-- CONTENT -->
            <div class="p-6">
                <?php
                // Filter live videos from admin videos
                $live_videos = array_filter($admin_videos, function ($video) {
                    return isset($video->video_type) && $video->video_type === 'live';
                });
                ?>
                <?php if (!empty($live_videos)): ?>
                    <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 xl:grid-cols-4 gap-6">
                        <?php foreach ($live_videos as $video): ?>
                            <a href="<?= site_url('watch-video/' . $video->id) ?>"
                                class="group bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-xl overflow-hidden shadow-sm hover:shadow-xl transition-all duration-300">

                                <!-- Thumbnail -->
                                <div class="relative overflow-hidden">
                                    <img src="<?= !empty($video->thumbnail) ? base_url($video->thumbnail) : base_url('assets/sbadmin2/img/video-placeholder.png') ?>"
                                        alt="Thumbnail"
                                        class="w-full h-48 object-cover group-hover:scale-105 transition-transform duration-300" />
                                    <div
                                        class="absolute top-2 right-2 bg-red-600 text-white text-xs px-2 py-1 rounded-full animate-pulse">
                                        LIVE
                                    </div>
                                    <div
                                        class="absolute inset-0 bg-black bg-opacity-0 group-hover:bg-opacity-20 transition-all duration-300">
                                    </div>
                                </div>

                                <!-- Info -->
                                <div class="p-4">
                                    <h3
                                        class="text-sm font-semibold text-gray-900 dark:text-white group-hover:text-green-600 line-clamp-2">
                                        <?= htmlspecialchars($video->title) ?>
                                    </h3>
                                    <p class="text-xs text-gray-600 dark:text-gray-300 mt-1 line-clamp-2">
                                        <?= word_limiter(strip_tags($video->description), 12) ?>
                                    </p>
                                    <div class="flex items-center text-xs text-gray-400 mt-2">
                                        <i class="far fa-clock mr-1"></i>
                                        <?= date('M d, Y', strtotime($video->created_at)) ?>
                                    </div>
                                </div>
                            </a>
                        <?php endforeach; ?>
                    </div>
                <?php else: ?>
                    <div class="text-center text-gray-500 dark:text-gray-400 text-sm">
                        Tidak ada live streaming saat ini. Tunggu pembaruan terbaru.
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <!-- Admin Videos -->
    <section class="my-10">
        <div
            class="bg-white dark:bg-gray-900 rounded-2xl shadow-xl border border-red-600 dark:border-red-700 overflow-hidden">

            <!-- HEADER -->
            <div
                class="bg-gradient-to-r from-red-600 to-red-500 text-white px-6 py-4 flex justify-between items-center">
                <div class="flex items-center gap-3 text-lg font-bold">
                    <i class="fas fa-video text-xl"></i>
                    <span>Video dari Admin</span>
                </div>
                <span class="bg-secondary text-secondary font-semibold px-4 py-1 rounded-full text-sm shadow">
                    <?= count($admin_videos) ?> Video
                </span>
            </div>

            <!-- CONTENT -->
            <div class="p-6">
                <?php if (!empty($admin_videos)): ?>
                    <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 xl:grid-cols-4 gap-6">
                        <?php foreach ($admin_videos as $video): ?>
                            <a href="<?= site_url('watch-video/' . $video->id) ?>"
                                class="group bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-xl overflow-hidden shadow-sm hover:shadow-xl transition-all duration-300">

                                <!-- Thumbnail -->
                                <div class="relative overflow-hidden">
                                    <img src="<?= !empty($video->thumbnail) ? base_url($video->thumbnail) : base_url('assets/sbadmin2/img/video-placeholder.png') ?>"
                                        alt="Thumbnail"
                                        class="w-full h-48 object-cover group-hover:scale-105 transition-transform duration-300" />
                                    <div
                                        class="absolute inset-0 bg-black bg-opacity-0 group-hover:bg-opacity-20 transition-all duration-300">
                                    </div>
                                </div>

                                <!-- Info -->
                                <div class="p-4">
                                    <h3
                                        class="text-sm font-semibold text-gray-900 dark:text-white group-hover:text-red-600 line-clamp-2">
                                        <?= htmlspecialchars($video->title) ?>
                                    </h3>
                                    <p class="text-xs text-gray-600 dark:text-gray-300 mt-1 line-clamp-2">
                                        <?= word_limiter(strip_tags($video->description), 12) ?>
                                    </p>
                                    <div class="flex items-center text-xs text-gray-400 mt-2">
                                        <i class="far fa-clock mr-1"></i>
                                        <?= date('M d, Y', strtotime($video->created_at)) ?>
                                    </div>
                                </div>
                            </a>
                        <?php endforeach; ?>
                    </div>
                <?php else: ?>
                    <div class="text-center text-gray-500 dark:text-gray-400 text-sm">
                        Belum ada video dari admin. Tunggu pembaruan terbaru.
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>

</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const mobileToggleBtn = document.getElementById('mobileSidebarToggle');
        const sidebar = document.getElementById('accordionSidebar');

        if (mobileToggleBtn) {
            mobileToggleBtn.addEventListener('click', function () {
                sidebar.classList.toggle('expanded');
            });
        }
    });
</script>