<?php $role = $this->session->userdata('role'); ?>

<style>
    #accordionSidebar {
        background: var(--primary-color);
        /* Changed from gradient to solid color for better visibility */
        box-shadow: 2px 0 8px rgba(0, 0, 0, 0.7);
        width: 70px;
        transition: width 0.3s, box-shadow 0.3s;
        overflow-x: hidden;
        color: #fff;
    }

    #accordionSidebar.expanded {
        width: 220px;
        box-shadow: 4px 0 12px rgba(0, 0, 0, 0.8);
    }

    .sidebar-profile {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        padding: 1rem 0;
        text-align: center;
    }

    .sidebar-profile img {
        width: 60px;
        height: 60px;
        border-radius: 50%;
        object-fit: cover;
        border: 2px solid #fff;
        box-shadow: 0 0 8px rgba(0, 0, 0, 0.5);
        margin-bottom: 0.5rem;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .sidebar-profile img:hover {
        transform: scale(1.1);
        box-shadow: 0 0 12px rgba(255, 255, 255, 0.8);
    }

    .sidebar-profile h5 {
        margin: 0;
        font-weight: 700;
        font-size: 1.2rem;
    }

    .sidebar-profile small {
        font-size: 0.9rem;
        color: #c0c0c0;
    }

    .nav-item .nav-link {
        text-align: center;
        color: #d1d3e2;
        padding: 0.75rem 1rem;
        transition: background-color 0.3s ease, color 0.3s ease;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .nav-item .nav-link i {
        transition: color 0.3s ease;
        font-size: 1.2rem;
    }

    .nav-item .nav-link span {
        display: none;
    }

    #accordionSidebar.expanded .nav-item .nav-link span {
        display: inline;
        margin-left: 0.5rem;
    }

    .nav-item .nav-link:hover,
    .nav-item.active .nav-link {
        background-color: none;
        color: #fff;
        border-radius: 0.375rem;
    }

    .nav-item .nav-link:hover i,
    .nav-item.active .nav-link i {
        color: #00ff1aff;
    }

    .sidebar-divider {
        border-top: 1px solid rgba(255, 255, 255, 0.3);
        margin: 0.5rem 0;
        box-shadow: 0 1px 2px rgba(0, 0, 0, 0.2);
    }

    /* Show toggle button only on mobile */
    #sidebarToggle {
        display: none;
        background: transparent;
        border: none;
        cursor: pointer;
        color: white;
        font-size: 1.5rem;
        padding: 0.5rem;
    }

    @media (max-width: 768px) {
        #accordionSidebar>div {
            flex: 1 1 auto;
            overflow-y: auto;
            padding-bottom: 60px;
            /* space for logout button */
        }
    }

    @media (max-width: 768px) {
        #sidebarToggle {
            display: block;
        }

        #accordionSidebar {
            position: fixed;
            top: 0;
            left: 0;
            height: 100vh;
            z-index: 1050;
            width: 0;
            overflow-x: hidden;
            overflow-y: auto;
            -webkit-overflow-scrolling: touch;
            transition: width 0.3s ease;
            display: flex;
            flex-direction: column;
        }

        #accordionSidebar.expanded {
            width: 280px;
        }

        /* Increase profile photo size on mobile */
        .sidebar-profile img.profile-photo-frame {
            width: 120px;
            height: 120px;
        }

        /* Adjust nav-link layout and sizes on mobile */
        .nav-item .nav-link {
            justify-content: flex-start;
            padding-left: 1rem;
        }

        /* Increase nav-link icon size on mobile */
        .nav-item .nav-link i {
            font-size: 1.8rem;
        }

        /* Show nav-link text on mobile when expanded */
        #accordionSidebar.expanded .nav-item .nav-link span {
            display: inline;
            margin-left: 1rem;
            font-size: 1.3rem;
            white-space: nowrap;
        }
    }

    /* Fullscreen modal styles */
    .profile-photo-modal {
        position: fixed;
        top: 0;
        left: 0;
        width: 100vw;
        height: 100vh;
        background: rgba(0, 0, 0, 0.8);
        backdrop-filter: blur(8px);
        display: flex;
        justify-content: center;
        align-items: center;
        opacity: 0;
        pointer-events: none;
        transition: opacity 0.3s ease;
        z-index: 2000;
    }

    .profile-photo-modal.active {
        opacity: 1;
        pointer-events: auto;
    }

    .profile-photo-modal-content {
        position: relative;
        max-width: 90vw;
        max-height: 90vh;
        animation: zoomIn 0.3s ease forwards;
        border-radius: 12px;
        overflow: hidden;
        box-shadow: 0 0 20px rgba(0, 0, 0, 0.7);
    }

    .profile-photo-modal-content img {
        width: 100%;
        height: auto;
        display: block;
        border-radius: 12px;
        object-fit: contain;
    }

    .profile-photo-modal-close {
        position: absolute;
        top: 8px;
        right: 8px;
        background: rgba(0, 0, 0, 0.5);
        border: none;
        color: white;
        font-size: 1.5rem;
        padding: 4px 8px;
        border-radius: 6px;
        cursor: pointer;
        transition: background 0.3s ease;
        z-index: 10;
    }

    .profile-photo-modal-close:hover {
        background: rgba(0, 0, 0, 0.8);
    }

    @keyframes zoomIn {
        0% {
            transform: scale(0.7);
            opacity: 0;
        }

        100% {
            transform: scale(1);
            opacity: 1;
        }
    }

    @media (max-width: 600px) {
        .profile-photo-modal-content {
            max-width: 95vw;
            max-height: 80vh;
        }
    }
</style>

<ul class="navbar-nav bg-gradient-primary sidebar sidebar-dark accordion <?php if (uri_string() === 'admin/upload-video')
    echo 'expanded'; ?>" id="accordionSidebar">

    <!-- Profile Section -->
    <?php if ($role): ?>
        <div class="sidebar-profile text-center my-4">
            <?php
            $profile_photo = $this->session->userdata('profile_photo');
            $default_photo = base_url('assets/sbadmin2/img/default-profile.png');
            $profile_photo_path = $default_photo;
            if ($profile_photo) {
                $photo_path = FCPATH . 'assets/sbadmin2/uploads/' . $profile_photo;
                if (file_exists($photo_path)) {
                    $profile_photo_path = base_url('assets/sbadmin2/uploads/' . $profile_photo);
                }
            }
            $user_name = $this->session->userdata('username') ?? $this->session->userdata('name') ?? $this->session->userdata('email') ?? '';
            $user_role = ucfirst($role);
            ?>
            <?php
            $theme_color = $this->session->userdata('theme_color') ?? '#0b3d0b';

            // Define available frame styles
            $frame_styles = [
                'green' => 'border: 3px solid #0b3d0b; box-shadow: 0 0 8px rgba(0, 0, 0, 0.3);',
                'blue' => 'border: 3px solid #004080; box-shadow: 0 0 8px rgba(0, 0, 128, 0.3);',
                'red' => 'border: 3px solid #800000; box-shadow: 0 0 8px rgba(128, 0, 0, 0.3);',
                'dashed' => 'border: 3px dashed #0b3d0b; box-shadow: 0 0 8px rgba(0, 0, 0, 0.3);',
                'shadow' => 'border: none; box-shadow: 0 0 12px rgba(0, 0, 0, 0.5);',
                'glow' => 'border: 3px solid #39ff14; box-shadow: 0 0 10px #39ff14, 0 0 20px #39ff14, 0 0 30px #39ff14;',
                'gradient' => 'border: 3px solid; border-image-slice: 1; border-width: 3px; border-image-source: linear-gradient(45deg, #f3ec78, #af4261); box-shadow: 0 0 8px rgba(175, 66, 97, 0.5);',
                'futuristic' => 'border: 3px solid #00ffff; box-shadow: 0 0 8px #00ffff, 0 0 15px #00ffff, 0 0 20px #00ffff;',
                'classic' => 'border: 3px solid #000000; box-shadow: none;',
                'neon' => 'border: 3px solid #ff00ff; box-shadow: 0 0 5px #ff00ff, 0 0 10px #ff00ff, 0 0 20px #ff00ff;',
            ];

            $selected_frame_style = $this->session->userdata('profile_frame_style') ?? 'green';
            $selected_style_css = $frame_styles[$selected_frame_style] ?? $frame_styles['green'];
            ?>
            <style>
                .profile-photo-frame {
                    border-radius: 50%;
                    transition: transform 0.3s ease, box-shadow 0.3s ease;
                    width: 100px;
                    height: 100px;
                    object-fit: cover;
                }

                .profile-photo-frame:hover {
                    transform: scale(1.05);
                    box-shadow: 0 0 12px rgba(0, 0, 0, 0.5);
                }
            </style>
            <img src="<?= $profile_photo_path ?>" alt="Profile Photo" class="profile-photo-frame"
                style="<?= $selected_style_css ?>" id="sidebarProfilePhoto">
            <h5 class="mt-3 mb-0 font-weight-bold text-white"><?= htmlspecialchars($user_name) ?></h5>
            <small class="text-light"><?= htmlspecialchars($user_role) ?></small>
        </div>
    <?php endif; ?>

    <hr class="sidebar-divider my-0" />

    <!-- Menu Items -->
    <div style="display:flex; flex-direction:column; height:100%;">
        <div style="flex:1;">
            <?php if ($role === 'admin'): ?>
                <li class="nav-item <?= uri_string() == 'admin' ? 'active' : '' ?>">
                    <a class="nav-link" href="<?= site_url('admin') ?>"><i class="fas fa-fw fa-tachometer-alt"></i>
                        <span>Dashboard</span></a>
                </li>
                <hr class="sidebar-divider">
                <div class="sidebar-heading text-white pl-3">Management</div>
                <li class="nav-item <?= uri_string() == 'admin/manage_videos' ? 'active' : '' ?>">
                    <a class="nav-link" href="<?= site_url('admin/manage_videos') ?>"><i class="fas fa-fw fa-video"></i>
                        <span>Manage Videos</span></a>
                </li>
                <li class="nav-item <?= uri_string() == 'admin/upload-video' ? 'active' : '' ?>">
                    <a class="nav-link" href="<?= site_url('admin/upload-video') ?>"><i class="fas fa-fw fa-upload"></i>
                        <span>Upload Video</span></a>
                </li>
                <li class="nav-item <?= uri_string() == 'admin/users' ? 'active' : '' ?>">
                    <a class="nav-link" href="<?= site_url('admin/users') ?>"><i class="fas fa-fw fa-users"></i>
                        <span>Manage
                            Users</span></a>
                </li>
                <li class="nav-item <?= uri_string() == 'auth/register' ? 'active' : '' ?>">
                    <a class="nav-link" href="<?= site_url('admin/add_user') ?>"><i class="fas fa-fw fa-user-plus"></i>
                        <span>Add
                            User</span></a>
                </li>
                <li class="nav-item <?= uri_string() == 'settings/theme' ? 'active' : '' ?>">
                    <a class="nav-link" href="<?= site_url('settings/theme') ?>"><i class="fas fa-fw fa-cog"></i>
                        <span>Settings</span></a>
                </li>
                <li class="nav-item <?= uri_string() == 'settings/maintenance' ? 'active' : '' ?>">
                    <a class="nav-link" href="<?= site_url('settings/maintenance') ?>"><i class="fas fa-fw fa-tools"></i>
                        <span>Maintenance</span></a>
                </li>

                <!-- ===== User Sidebar Mobile ===== -->

            <?php elseif ($role === 'user'): ?>
                <li class="nav-item <?= uri_string() == 'dashboard' ? 'active' : '' ?>">
                    <a class="nav-link" href="<?= site_url('dashboard') ?>"><i class="fas fa-fw fa-tachometer-alt"></i>
                        <span>Dashboard</span></a>
                </li>

                <!-- Account Menu with Submenu -->
                <li class="nav-item">
                    <a class="nav-link collapsed" href="javascript:void(0);" aria-expanded="false"
                        aria-controls="accountMenu"
                        onclick="document.getElementById('accountMenu').classList.toggle('hidden');">
                        <i class="fas fa-fw fa-user-circle"></i>
                        <span>Account</span>
                    </a>
                    <div id="accountMenu" class="hidden submenu-transparent rounded-b-lg">
                        <a class="block px-4 py-2 text-white hover:bg-green-600" href="<?= site_url('myprofile') ?>">
                            <i class="fas fa-user mr-2"></i>My Profile
                        </a>
                        <a class="block px-4 py-2 text-white hover:bg-green-600" href="<?= site_url('myvideo') ?>">
                            <i class="fas fa-video mr-2"></i>My Video
                        </a>
                    </div>
                </li>

                <li class="nav-item <?= uri_string() == 'upload-video' ? 'active' : '' ?>">
                    <a class="nav-link" href="<?= site_url('upload-video') ?>"><i class="fas fa-fw fa-upload"></i>
                        <span>Upload
                            Video</span></a>
                </li>
                <li class="nav-item <?= uri_string() == 'live-video' ? 'active' : '' ?>">
                    <a class="nav-link" href="<?= site_url('live-video') ?>"><i class="fas fa-fw fa-signal"></i> <span>Live
                            Video</span></a>
                </li>
                <li class="nav-item">
                    <a class="nav-link collapsed" href="javascript:void(0);" aria-expanded="false"
                        aria-controls="settingsMenu"
                        onclick="document.getElementById('settingsMenu').classList.toggle('hidden');">
                        <i class="fas fa-fw fa-cog"></i>
                        <span>Settings</span>
                    </a>
                    <div id="settingsMenu" class="hidden submenu-transparent rounded-b-lg">
                        <a class="block px-4 py-2 text-white hover:bg-green-600"
                            href="<?= site_url('user/forgot_password') ?>">
                            <i class="fas fa-key mr-2"></i>Lupa Password
                        </a>
                        <a class="block px-4 py-2 text-white hover:bg-green-600" href="<?= site_url('theme') ?>">
                            <i class="fas fas fa-palette mr-2"></i>Setting Color
                        </a>
                    </div>
                </li>

                <!-- Tombol Logout di bawah Settings -->
                <li class="nav-item">
                    <a class="nav-link" href="<?= site_url('auth/logout') ?>" onclick="return confirm('Yakin ingin logout?')">
                        <i class="fas fa-sign-out-alt fa-sm fa-fw mr-2 text-gray-400"></i> <span>Logout</span>
                    </a>
                </li>

            <?php else: ?>
                <li class="nav-item <?= uri_string() == 'auth/login' ? 'active' : '' ?>">
                    <a class="nav-link" href="<?= site_url('auth/login') ?>"><i class="fas fa-fw fa-sign-in-alt"></i>
                        <span>Login</span></a>
                </li>
            <?php endif; ?>
        </div>
        
        <!-- Tombol Logout di Paling Bawah (untuk admin) -->
        <?php if ($role === 'admin'): ?>
            <li class="nav-item mt-auto">
                <a class="nav-link" href="<?= site_url('auth/logout') ?>" onclick="return confirm('Yakin ingin logout?')">
                    <i class="fas fa-sign-out-alt fa-sm fa-fw mr-2 text-gray-400"></i> <span>Logout</span>
                </a>
            </li>
        <?php endif; ?>
    </div>
</ul>

<!-- Fullscreen Profile Photo Modal -->
<div id="sidebarProfilePhotoModal" class="profile-photo-modal" aria-hidden="true" role="dialog" aria-modal="true">
    <div class="profile-photo-modal-content" role="document">
        <button class="profile-photo-modal-close" aria-label="Close">&times;</button>
        <img src="" alt="Profile Photo Fullscreen" id="sidebarProfilePhotoModalImg">
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const sidebar = document.getElementById('accordionSidebar');
        const toggleBtn = document.getElementById('sidebarToggle');

        if (toggleBtn) {
            toggleBtn.addEventListener('click', function () {
                sidebar.classList.toggle('expanded');
            });
        }

        // Sidebar profile photo modal logic
        const profilePhoto = document.getElementById('sidebarProfilePhoto');
        const modal = document.getElementById('sidebarProfilePhotoModal');
        const modalImg = document.getElementById('sidebarProfilePhotoModalImg');
        const closeBtn = modal.querySelector('.profile-photo-modal-close');

        if (profilePhoto && modal && modalImg && closeBtn) {
            profilePhoto.addEventListener('click', function () {
                modalImg.src = this.src;
                modal.classList.add('active');
                modal.setAttribute('aria-hidden', 'false');
            });

            closeBtn.addEventListener('click', function () {
                modal.classList.remove('active');
                modal.setAttribute('aria-hidden', 'true');
                modalImg.src = '';
            });

            modal.addEventListener('click', function (e) {
                if (e.target === modal) {
                    modal.classList.remove('active');
                    modal.setAttribute('aria-hidden', 'true');
                    modalImg.src = '';
                }
            });
        }
    });
</script>