<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<?php
// Load the theme CSS styles using the helper function
if (function_exists('apply_theme')) {
    echo apply_theme();
}
?>

<div class="container mt-4">
    <h1>Theme Settings</h1>
    <?php if ($this->session->flashdata('success')): ?>
        <div class="alert alert-success"><?= $this->session->flashdata('success') ?></div>
    <?php endif; ?>
    <?php if ($this->session->flashdata('error')): ?>
        <div class="alert alert-danger"><?= $this->session->flashdata('error') ?></div>
    <?php endif; ?>

    <form action="<?= site_url('settings/update_theme') ?>" method="post" enctype="multipart/form-data">
        <div class="form-group">
            <label for="primary_color">Primary Color</label>
            <input type="color" id="primary_color" name="primary_color"
                value="<?= htmlspecialchars($settings->primary_color ?? '#4e73df') ?>" class="form-control" required>
        </div>

        <div class="form-group">
            <label for="secondary_color">Secondary Color</label>
            <input type="color" id="secondary_color" name="secondary_color"
                value="<?= htmlspecialchars($settings->secondary_color ?? '#1cc88a') ?>" class="form-control" required>
        </div>

        <div class="form-group">
            <label for="text_color">Text Color</label>
            <input type="color" id="text_color" name="text_color"
                value="<?= htmlspecialchars($settings->text_color ?? '#000000') ?>" class="form-control" required>
        </div>

        <div class="form-group">
            <label for="background_type">Background Type</label>
            <select id="background_type" name="background_type" class="form-control" required>
                <option value="color" <?= isset($settings) && $settings->background_type === 'color' ? 'selected' : '' ?>>Color</option>
                <option value="gradient" <?= isset($settings) && $settings->background_type === 'gradient' ? 'selected' : '' ?>>Gradient</option>
                <option value="image" <?= isset($settings) && $settings->background_type === 'image' ? 'selected' : '' ?>>Image</option>
            </select>
        </div>

        <div class="form-group" id="background_color_group" style="display: none;">
            <label for="background_color">Background Color</label>
            <input type="color" id="background_color" name="background_color"
                value="<?= htmlspecialchars((isset($settings) && $settings->background_type === 'color') ? $settings->background_value : '#ffffff') ?>"
                class="form-control">
        </div>

        <div class="form-group" id="background_gradient_group" style="display: none;">
            <label for="background_gradient">Background Gradient</label>
            <input type="text" id="background_gradient" name="background_gradient"
                value="<?= htmlspecialchars((isset($settings) && $settings->background_type === 'gradient') ? $settings->background_value : '') ?>"
                class="form-control" placeholder="e.g. linear-gradient(135deg, #667eea 0%, #764ba2 100%)">
        </div>

        <div class="form-group" id="background_image_group" style="display: none;">
            <label for="background_image">Background Image</label>
            <input type="file" id="background_image" name="background_image" accept="image/*" class="form-control-file">
            <?php if (isset($settings) && $settings->background_type === 'image' && !empty($settings->background_value)): ?>
                <img src="<?= base_url('uploads/backgrounds/' . $settings->background_value) ?>" alt="Background Image"
                    style="max-width: 200px; margin-top: 10px;">
            <?php endif; ?>
        </div>

        <div class="form-group form-check">
            <input type="checkbox" id="background_overlay" name="background_overlay" class="form-check-input"
                <?= (isset($settings) && !empty($settings->background_overlay)) ? 'checked' : '' ?>>
            <label for="background_overlay" class="form-check-label">Enable Background Overlay</label>
        </div>

        <button type="submit" class="btn btn-primary">Save Theme</button>
        <a href="<?= site_url('settings/reset_theme') ?>" class="btn btn-secondary">Reset to Default</a>
    </form>
</div>

<script>
    function toggleBackgroundFields() {
        var type = document.getElementById('background_type').value;
        document.getElementById('background_color_group').style.display = (type === 'color') ? 'block' : 'none';
        document.getElementById('background_gradient_group').style.display = (type === 'gradient') ? 'block' : 'none';
        document.getElementById('background_image_group').style.display = (type === 'image') ? 'block' : 'none';
    }

    document.getElementById('background_type').addEventListener('change', toggleBackgroundFields);
    window.onload = toggleBackgroundFields;
</script>
