<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Maintenance Mode</title>
    <style>
        body {
            margin: 0;
            background-color: #1e2a38;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: #ffffff;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            text-align: center;
            padding: 20px;
        }

        .illustration {
            max-width: 500px;
            margin-bottom: 30px;
        }

        h1 {
            font-size: 1.6rem;
            margin-bottom: 10px;
            font-weight: bold;
        }

        p.message {
            font-size: 1rem;
            margin-bottom: 30px;
            color: #bdc3c7;
        }

        .social-icons {
            display: flex;
            justify-content: center;
            gap: 12px;
            margin-top: 20px;
            flex-wrap: wrap;
        }

        .social-icons a {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 36px;
            height: 36px;
            background-color: #243447;
            border-radius: 8px;
            text-decoration: none;
            color: #ecf0f1;
            font-size: 18px;
            transition: all 0.3s ease;
        }

        .social-icons a:hover {
            background-color: #f39c12;
            transform: scale(1.1);
        }
    </style>
</head>
<body>

    <!-- Gambar ilustrasi -->
    <img class="illustration" src="<?php echo base_url('assets/sbadmin2/img/maintenance_illustration.png'); ?>" alt="Maintenance Illustration" />

    <!-- Pesan maintenance -->
    <h1>Sorry, we're doing some construction work on the site</h1>
    <p class="message">
        Thank you for being patient. We are doing some work on the site and will be back shortly.
    </p>

    <!-- Ikon sosial -->
    <div class="social-icons">
        <a href="#" aria-label="Facebook" title="Facebook">F</a>
        <a href="#" aria-label="Twitter" title="Twitter">T</a>
        <a href="#" aria-label="Google Plus" title="Google Plus">G+</a>
        <a href="#" aria-label="LinkedIn" title="LinkedIn">in</a>
        <a href="#" aria-label="YouTube" title="YouTube">YT</a>
        <a href="#" aria-label="Pinterest" title="Pinterest">P</a>
        <a href="#" aria-label="Behance" title="Behance">B</a>
        <a href="#" aria-label="Instagram" title="Instagram">I</a>
        <a href="#" aria-label="Email" title="Email">@</a>
    </div>

</body>
</html>
