<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8" />
    <title>Register Akun</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            background-image: url('https://i.pinimg.com/1200x/91/7f/a7/917fa744e3e6c007ea242d8537e6fa42.jpg');
            background-size: cover;
            background-position: center;
            font-family: 'Inter', sans-serif;
        }

        .glass-box {
            background: rgba(255, 255, 255, 0.06);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border-radius: 1rem;
            border: 1px solid rgba(255, 255, 255, 0.15);
        }

        input::placeholder {
            color: #ccc;
        }
    </style>
</head>

<body class="flex items-center justify-center min-h-screen text-white">

    <div class="glass-box w-full max-w-md p-8 shadow-lg">
        <h2 class="text-3xl font-bold text-center mb-2">Register</h2>
        <p class="text-center text-sm text-gray-300 mb-6">Silakan isi data untuk membuat akun</p>

        <?php if ($this->session->flashdata('success')): ?>
            <div class="bg-green-600 text-white px-4 py-2 rounded mb-4 text-sm">
                <?= $this->session->flashdata('success'); ?>
            </div>
        <?php endif; ?>

        <?= validation_errors('<div class="text-red-400 mb-2 text-sm">', '</div>'); ?>

        <form method="post" class="space-y-4">
            <input type="email" name="email" placeholder="Email"
                class="w-full px-4 py-3 bg-black/30 border border-white/20 rounded focus:outline-none focus:ring-2 focus:ring-purple-500"
                required />

            <input type="password" name="password" placeholder="Password"
                class="w-full px-4 py-3 bg-black/30 border border-white/20 rounded focus:outline-none focus:ring-2 focus:ring-purple-500"
                required />

            <input type="password" name="confirm_password" placeholder="Ulangi Password"
                class="w-full px-4 py-3 bg-black/30 border border-white/20 rounded focus:outline-none focus:ring-2 focus:ring-purple-500"
                required />

            <button type="submit"
                class="w-full py-3 rounded bg-purple-600 hover:bg-purple-700 transition font-semibold text-lg">
                Daftar
            </button>
        </form>

        <p class="mt-6 text-center text-sm text-gray-300">
            Sudah punya akun? <a href="<?= base_url('login') ?>" class="text-white hover:underline">Login di sini</a>
        </p>
    </div>

</body>

</html>