<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Login</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body {
            background-image: url('https://i.pinimg.com/1200x/91/7f/a7/917fa744e3e6c007ea242d8537e6fa42.jpg');
            background-size: cover;
            background-position: center;
        }

        .glass-box {
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border-radius: 1rem;
            border: 1px solid rgba(255, 255, 255, 0.15);
        }

        input::placeholder {
            color: #fff;
        }
    </style>
</head>

<body class="flex items-center justify-center min-h-screen text-white">
    <div class="glass-box w-full max-w-md p-8 shadow-lg">
        <h2 class="text-3xl font-bold text-center mb-8">Login</h2>
        <form method="post" action="<?= site_url('login') ?>">
            <div class="mb-4">
                <input type="email" name="email" placeholder="Email"
                    class="w-full px-4 py-3 bg-black/30 border border-white/20 rounded focus:outline-none focus:ring-2 focus:ring-purple-500"
                    required />
            </div>
            <div class="mb-6">
                <input type="password" name="password" placeholder="Password"
                    class="w-full px-4 py-3 bg-black/30 border border-white/20 rounded focus:outline-none focus:ring-2 focus:ring-purple-500"
                    required />
            </div>
            <button type="submit"
                class="w-full py-3 rounded bg-purple-600 hover:bg-purple-700 transition font-semibold text-lg">Login</button>
        </form>
        <p class="mt-6 text-center text-sm text-gray-300">
            Not a member? <a href="<?= site_url('register') ?>" class="text-white hover:underline">Sign Up</a>
        </p>
    </div>
</body>

</html>