<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800">Manage Users</h1>

    <?php if ($this->session->flashdata('success')): ?>
        <div class="alert alert-success"><?= $this->session->flashdata('success') ?></div>
    <?php endif; ?>

    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>ID</th>
                <th>Username</th>
                <th>Email</th>
                <th>Role</th>
                <th>Created At</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php if (!empty($users)): ?>
                <?php foreach ($users as $user): ?>
                    <tr>
                        <td><?= $user->id ?></td>
                        <td>
                            <?php
                            if (!empty($user->username)) {
                                echo htmlspecialchars($user->username);
                            } else {
                                // fallback to email prefix before @
                                $email_prefix = strstr($user->email, '@', true);
                                echo htmlspecialchars($email_prefix ?: $user->email);
                            }
                            ?>
                        </td>
                        <td><?= htmlspecialchars($user->email) ?></td>
                        <td><?= htmlspecialchars($user->role) ?></td>
                        <td><?= $user->created_at ?></td>
                        <td>
                            <a href="<?= site_url('admin/edit_user/' . $user->id) ?>" class="btn btn-sm btn-primary">Edit</a>
                            <a href="<?= site_url('admin/delete_user/' . $user->id) ?>" class="btn btn-sm btn-danger"
                                onclick="return confirm('Are you sure you want to delete this user?');">Delete</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="6" class="text-center">No users found.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>