<div class="container-fluid px-4">
    <h1 class="mt-4 text-white font-bold text-3xl drop-shadow">Upload Video / Live Stream</h1>
    <p class="text-white mb-4">Tambahkan video baru atau streaming langsung ke platform Anda</p>

    <?php if (validation_errors()): ?>
        <div class="alert alert-danger" role="alert">
            <?= validation_errors() ?>
        </div>
    <?php endif; ?>

    <div class="card glass-card shadow-lg rounded-lg p-4">
        <form method="post" enctype="multipart/form-data" action="<?= base_url('admin/upload_video') ?>" class="space-y-5">
            <!-- Title -->
            <div>
                <label for="title" class="block text-gray-900 font-medium mb-2">Video Title</label>
                <input type="text" name="title" id="title" required value="<?= set_value('title') ?>"
                    class="w-full px-4 py-2 rounded-lg bg-white focus:ring-2 focus:ring-indigo-400 focus:outline-none" />
            </div>

            <!-- Description -->
            <div>
                <label for="description" class="block text-gray-900 font-medium mb-2">Description</label>
                <textarea name="description" id="description" rows="4" required
                    class="w-full px-4 py-2 rounded-lg bg-white focus:ring-2 focus:ring-indigo-400 focus:outline-none resize-none"><?= set_value('description') ?></textarea>
            </div>

            <!-- Video Type -->
            <div>
                <label for="video_type" class="block text-gray-900 font-medium mb-2">Video Type</label>
                <select name="video_type" id="video_type" class="w-full px-4 py-2 rounded-lg bg-white focus:ring-2 focus:ring-indigo-400 focus:outline-none">
                    <option value="recorded" <?= set_select('video_type', 'recorded', TRUE) ?>>Recorded (Biasa)</option>
                    <option value="live" <?= set_select('video_type', 'live') ?>>Live</option>
                </select>
            </div>

            <!-- Video File -->
            <div>
                <label for="video_file" class="block text-gray-900 font-medium mb-2">Upload Video File</label>
                <input type="file" name="video_file" id="video_file" accept="video/*"
                    class="block w-full text-sm file:mr-4 file:py-2 file:px-4 file:rounded-md file:border-0 file:text-sm file:font-semibold file:bg-indigo-600 file:text-white hover:file:bg-indigo-700 transition" />
            </div>

            <!-- Thumbnail File -->
            <div>
                <label for="thumbnail_file" class="block text-gray-900 font-medium mb-2">Upload Thumbnail Image</label>
                <input type="file" name="thumbnail_file" id="thumbnail_file" accept="image/*"
                    class="block w-full text-sm file:mr-4 file:py-2 file:px-4 file:rounded-md file:border-0 file:text-sm file:font-semibold file:bg-pink-500 file:text-white hover:file:bg-pink-600 transition" />
            </div>

            <!-- Video Link -->
            <div>
                <label for="video_link" class="block text-gray-900 font-medium mb-2">Or Video Link (URL)</label>
                <input type="url" name="video_link" id="video_link" value="<?= set_value('video_link') ?>"
                    class="w-full px-4 py-2 rounded-lg bg-white focus:ring-2 focus:ring-indigo-400 focus:outline-none" />
            </div>

            <!-- Submit & Cancel -->
            <div class="space-y-3">
                <button type="submit"
                    class="w-full bg-indigo-600 hover:bg-indigo-700 text-white font-semibold py-3 rounded-lg transition duration-200">
                    Upload Video
                </button>
                <a href="<?= site_url('admin/manage_videos') ?>"
                    class="block w-full text-center bg-gray-300 hover:bg-gray-400 text-gray-800 font-semibold py-3 rounded-lg transition duration-200">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</div>
