<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800">Manage Videos</h1>

    <?php if ($this->session->flashdata('success')): ?>
        <div class="alert alert-success"><?= $this->session->flashdata('success') ?></div>
    <?php endif; ?>

    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>ID</th>
                <th>Title</th>
                <th>Video Type</th>
                <th>Source Type</th>
                <th>Source</th>
                <th>Uploaded By</th>
                <th>Created At</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php if (!empty($videos)): ?>
                <?php foreach ($videos as $video): ?>
                    <tr>
                        <td><?= $video->id ?></td>
                        <td><?= htmlspecialchars($video->title) ?></td>
                        <td><?= htmlspecialchars($video->video_type) ?></td>
                        <td><?= htmlspecialchars($video->source_type) ?></td>
                        <td>
                            <?php if ($video->source_type === 'file'): ?>
                                <a href="<?= base_url($video->source) ?>" target="_blank">View File</a>
                            <?php else: ?>
                                <a href="<?= htmlspecialchars($video->source) ?>" target="_blank">View Link</a>
                            <?php endif; ?>
                        </td>
                        <td><?= $video->user_id ?></td>
                        <td><?= $video->created_at ?></td>
                        <td>
                            <a href="<?= site_url('admin/edit_video/' . $video->id) ?>" class="btn btn-sm btn-primary">Edit</a>
                            <a href="<?= site_url('admin/delete_video/' . $video->id) ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this video?');">Delete</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr><td colspan="8" class="text-center">No videos found.</td></tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>
