<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800">Edit Video</h1>

    <?php if (validation_errors()): ?>
        <div class="alert alert-danger">
            <?= validation_errors() ?>
        </div>
    <?php endif; ?>

    <form method="post" action="<?= site_url('admin/edit_video/' . $video->id) ?>">
        <div class="form-group">
            <label for="title">Title</label>
            <input type="text" name="title" class="form-control" id="title"
                value="<?= set_value('title', htmlspecialchars($video->title ?? '')) ?>" required>
        </div>
        <div class="form-group">
            <label for="source">Source</label>
            <input type="text" name="source" class="form-control" id="source"
                value="<?= set_value('source', htmlspecialchars($video->source ?? '')) ?>">
            <small class="form-text text-muted">Enter the video source URL or file path.</small>
        </div>
        <div class="form-group">
            <label for="video_type">Video Type</label>
            <select name="video_type" class="form-control" id="video_type">
                <option value="recorded" <?= set_select('video_type', 'recorded', $video->video_type === 'recorded') ?>>Recorded (Biasa)</option>
                <option value="live" <?= set_select('video_type', 'live', $video->video_type === 'live') ?>>Live</option>
            </select>
        </div>
        <button type="submit" class="btn btn-primary">Update Video</button>
        <a href="<?= site_url('admin/manage_videos') ?>" class="btn btn-secondary">Cancel</a>
    </form>
</div>
