<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800">Edit User</h1>

    <?php if (validation_errors()): ?>
        <div class="alert alert-danger">
            <?= validation_errors() ?>
        </div>
    <?php endif; ?>

<form method="post" action="<?= site_url('admin/edit_user/' . $user->id) ?>" enctype="multipart/form-data">
    <div class="form-group">
        <label for="username">Username</label>
        <input type="text" name="username" class="form-control" id="username"
            value="<?= set_value('username', htmlspecialchars($user->username ?? '')) ?>" required>
    </div>
    <div class="form-group">
        <label for="email">Email</label>
        <input type="email" name="email" class="form-control" id="email"
            value="<?= set_value('email', htmlspecialchars($user->email)) ?>" required>
    </div>
    <div class="form-group">
        <label for="password">New Password (leave blank to keep current)</label>
        <input type="password" name="password" class="form-control" id="password" autocomplete="new-password">
    </div>
    <div class="form-group">
        <label for="role">Role</label>
        <select name="role" id="role" class="form-control" required>
            <option value="user" <?= set_select('role', 'user', ($user->role ?? '') === 'user') ?>>User</option>
            <option value="admin" <?= set_select('role', 'admin', ($user->role ?? '') === 'admin') ?>>Admin</option>
        </select>
    </div>
    <div class="form-group">
        <label for="profile_photo">Profile Photo</label>
        <input type="file" name="profile_photo" id="profile_photo" class="form-control-file" accept="image/*">
        <?php if (!empty($user->profile_photo)): ?>
            <div class="mt-2">
                <img src="<?= base_url('assets/sbadmin2/uploads/' . $user->profile_photo) ?>" alt="Current Profile Photo" style="width: 80px; height: 80px; object-fit: cover; border-radius: 50%;">
            </div>
        <?php endif; ?>
    </div>
    <button type="submit" class="btn btn-primary">Update User</button>
    <a href="<?= site_url('admin/manage_users') ?>" class="btn btn-secondary">Cancel</a>
</form>
</div>