<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800">Admin Dashboard</h1>

    <div class="row">
        <!-- Users Statistic -->
        <div class="col-xl-4 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Total Users</div>
                    <div class="h5 mb-0 font-weight-bold text-gray-800"><?= $total_users ?? 0 ?></div>
                </div>
            </div>
        </div>

        <!-- Videos Statistic -->
        <div class="col-xl-4 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Total Videos</div>
                    <div class="h5 mb-0 font-weight-bold text-gray-800"><?= $total_videos ?? 0 ?></div>
                </div>
            </div>
        </div>
    </div>

    <!-- Login History Section -->
    <div class="card shadow mb-4 mt-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Login History</h6>
        </div>
        <div class="card-body">
            <?php if (!empty($login_history)): ?>
                <div class="table-responsive">
                    <table class="table table-bordered" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>Username</th>
                                <th>User Email</th>
                                <th>Login Time</th>
                                <th>Logout Time</th>
                                <th>Status</th>
                                <th>IP Address</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($login_history as $login): ?>
                                <tr>
                                    <td><?= htmlspecialchars($login->username ?? '-') ?></td>
                                    <td><?= htmlspecialchars($login->email) ?></td>
                                    <td><?= htmlspecialchars($login->login_time) ?></td>
                                    <td><?= htmlspecialchars($login->logout_time ?? '-') ?></td>
                                    <td>
                                        <?php if (is_null($login->logout_time)): ?>
                                            <span style="color: green;">&#9679; Online</span>
                                        <?php else: ?>
                                            <span style="color: red;">&#9679; Offline</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?= htmlspecialchars($login->ip_address) ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <p>No login history found.</p>
            <?php endif; ?>
        </div>
    </div>
</div>