<?php $this->load->helper('form'); ?>
<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800">Add User</h1>

    <?php if ($this->session->flashdata('success')): ?>
        <div class="alert alert-success"><?= $this->session->flashdata('success') ?></div>
    <?php endif; ?>

    <?php echo validation_errors('<div class="alert alert-danger">', '</div>'); ?>

    <?php echo form_open_multipart('admin/add_user'); ?>

    <div class="form-group">
        <label for="email">Username</label>
        <input type="name" class="form-control" id="username" name="username" value="<?= set_value('username') ?>" required>
    </div>

    <div class="form-group">
        <label for="email">Email</label>
        <input type="email" class="form-control" id="email" name="email" value="<?= set_value('email') ?>" required>
    </div>

    <div class="form-group">
        <label for="password">Password</label>
        <input type="password" class="form-control" id="password" name="password" required>
    </div>

    <div class="form-group">
        <label for="role">Role</label>
        <select class="form-control" id="role" name="role" required>
            <option value="">Select Role</option>
            <option value="user" <?= set_select('role', 'user') ?>>User</option>
            <option value="admin" <?= set_select('role', 'admin') ?>>Admin</option>
        </select>
    </div>

    <div class="form-group">
        <label for="profile_photo">Profile Photo</label>
        <input type="file" class="form-control-file" id="profile_photo" name="profile_photo" accept="image/*">
    </div>

    <button type="submit" class="btn btn-primary">Add User</button>

    <?php echo form_close(); ?>
</div>