<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Video_model extends CI_Model
{
    protected $table = 'videos';

    public function upload_video($data)
    {
        $this->db->insert($this->table, $data);
        return $this->db->insert_id(); // ini yang penting
    }

    public function get_videos_by_user($user_id)
    {
        return $this->db->get_where($this->table, ['user_id' => $user_id])->result();
    }

    public function get_video_by_id($video_id)
    {
        return $this->db->get_where($this->table, ['id' => $video_id])->row();
    }

    public function get_all_videos()
    {
        return $this->db->get($this->table)->result();
    }

    public function get_videos_by_admin()
    {
        $this->db->select('videos.*');
        $this->db->from('videos');
        $this->db->join('users', 'videos.user_id = users.id');
        $this->db->where_in('users.role', ['admin', 'superadmin', 'developer']);
        $query = $this->db->get();
        return $query->result();
    }

    public function update_video($video_id, $data)
    {
        $this->db->where('id', $video_id);
        return $this->db->update($this->table, $data);
    }

    public function delete_video($video_id)
    {
        return $this->db->delete($this->table, ['id' => $video_id]);
    }

    public function count_videos()
    {
        return $this->db->count_all($this->table);
    }
}
