<?php
defined('BASEPATH') or exit('No direct script access allowed');

class User_model extends CI_Model
{
    public function get_user_by_email($email)
    {
        return $this->db->get_where('users', ['email' => $email])->row();
    }

    public function insert_user($data)
    {
        return $this->db->insert('users', $data);
    }

    public function count_users()
    {
        return $this->db->count_all('users');
    }

    public function get_all_users()
    {
        $query = $this->db->get('users');
        return $query->result();
    }

    public function get_user_by_id($user_id)
    {
        return $this->db->get_where('users', ['id' => $user_id])->row();
    }

    public function update_user($user_id, $data)
    {
        $this->db->where('id', $user_id);
        return $this->db->update('users', $data);
    }

    public function delete_user($user_id)
    {
        $this->db->where('id', $user_id);
        return $this->db->delete('users');
    }

    /**
     * Generate password reset token for user
     */
    public function generate_reset_token($email)
    {
        $user = $this->get_user_by_email($email);
        if (!$user) {
            return false;
        }

        $token = bin2hex(random_bytes(32));
        $expires = date('Y-m-d H:i:s', strtotime('+1 hour'));

        $data = [
            'reset_token' => $token,
            'reset_expires' => $expires,
            'reset_used' => false
        ];

        $this->db->where('id', $user->id);
        $this->db->update('users', $data);

        return $token;
    }

    /**
     * Validate password reset token
     */
    public function validate_reset_token($token)
    {
        $this->db->where('reset_token', $token);
        $this->db->where('reset_expires >', date('Y-m-d H:i:s'));
        $this->db->where('reset_used', false);

        $user = $this->db->get('users')->row();

        if ($user) {
            return $user;
        }

        return false;
    }

    /**
     * Update password using reset token
     */
    public function update_password_by_token($token, $new_password)
    {
        $user = $this->validate_reset_token($token);
        if (!$user) {
            return false;
        }

        $data = [
            'password' => password_hash($new_password, PASSWORD_DEFAULT),
            'reset_token' => null,
            'reset_expires' => null,
            'reset_used' => true
        ];

        $this->db->where('id', $user->id);
        return $this->db->update('users', $data);
    }

    /**
     * Clear reset token for user
     */
    public function clear_reset_token($user_id)
    {
        $data = [
            'reset_token' => null,
            'reset_expires' => null,
            'reset_used' => false
        ];

        $this->db->where('id', $user_id);
        return $this->db->update('users', $data);
    }
}
