<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Settings_model extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
    }

    public function get_settings()
    {
        return $this->db->get('settings')->row();
    }

    public function update_settings($data)
    {
        $this->db->where('id', 1);
        return $this->db->update('settings', $data);
    }

    public function get_theme_colors()
    {
        $settings = $this->get_settings();
        if ($settings) {
            return [
                'primary' => $settings->primary_color,
                'secondary' => $settings->secondary_color,
                'text' => $settings->text_color ?? '#000000'
            ];
        }
        return [
            'primary' => '#4e73df',
            'secondary' => '#1cc88a',
            'text' => '#000000'
        ];
    }

    public function get_background_style()
    {
        $settings = $this->get_settings();
        if (!$settings) {
            return 'background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);';
        }

        $background_type = property_exists($settings, 'background_type') ? $settings->background_type : 'gradient';
        $background_value = property_exists($settings, 'background_value') ? $settings->background_value : 'linear-gradient(135deg, #667eea 0%, #764ba2 100%)';

        $style = '';
        switch ($background_type) {
            case 'color':
                $style = 'background-color: ' . $background_value . ';';
                break;
            case 'gradient':
                $style = 'background: ' . $background_value . ';';
                break;
            case 'image':
                $style = 'background-image: url(' . base_url('uploads/backgrounds/' . $background_value) . '); background-size: cover; background-position: center; background-repeat: no-repeat;';
                break;
        }
        return $style;
    }
}
