<?php
defined('BASEPATH') or exit('No direct script access allowed');

class PasswordReset_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Create password reset token
     */
    public function create_reset_token($email)
    {
        $token = bin2hex(random_bytes(32));
        $expires_at = date('Y-m-d H:i:s', strtotime('+1 hour'));

        $data = [
            'email' => $email,
            'token' => $token,
            'expires_at' => $expires_at
        ];

        $this->db->insert('password_resets', $data);
        return $token;
    }

    /**
     * Validate password reset token
     */
    public function validate_token($token)
    {
        $this->db->where('token', $token);
        $this->db->where('expires_at >', date('Y-m-d H:i:s'));

        $result = $this->db->get('password_resets')->row();

        if ($result) {
            return $result;
        }

        return false;
    }

    /**
     * Delete used/expired tokens
     */
    public function delete_token($token)
    {
        $this->db->where('token', $token);
        return $this->db->delete('password_resets');
    }

    /**
     * Delete all tokens for an email
     */
    public function delete_tokens_by_email($email)
    {
        $this->db->where('email', $email);
        return $this->db->delete('password_resets');
    }

    /**
     * Clean up expired tokens
     */
    public function cleanup_expired_tokens()
    {
        $this->db->where('expires_at <', date('Y-m-d H:i:s'));
        return $this->db->delete('password_resets');
    }
}
