<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Login_history_model extends CI_Model
{
    public function insert_login($user_id, $ip_address = null)
    {
        $data = [
            'user_id' => $user_id,
            'login_time' => date('Y-m-d H:i:s'),
            'ip_address' => $ip_address,
        ];
        return $this->db->insert('login_history', $data);
    }

    public function update_logout($user_id)
    {
        $this->db->set('logout_time', date('Y-m-d H:i:s'));
        $this->db->where('user_id', $user_id);
        $this->db->where('logout_time IS NULL', null, false);
        $this->db->order_by('login_time', 'DESC');
        $this->db->limit(1);
        return $this->db->update('login_history');
    }

    public function get_all_logins()
    {
        // Modifikasi query untuk memberikan fallback username jika NULL atau kosong
        $this->db->select('login_history.*, users.email, IFNULL(NULLIF(users.username, \'\'), "Unknown") as username');
        $this->db->from('login_history');
        $this->db->join('users', 'login_history.user_id = users.id', 'left');
        $this->db->order_by('login_time', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }
}
