<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Migration_add_maintenance_columns_to_settings extends CI_Migration
{
    public function up()
    {
        $fields = [
            'maintenance_mode' => [
                'type' => 'TINYINT',
                'constraint' => 1,
                'default' => 0,
                'after' => 'background_overlay'
            ],
            'maintenance_message' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => TRUE,
                'after' => 'maintenance_mode'
            ]
        ];
        $this->dbforge->add_column('settings', $fields);
    }

    public function down()
    {
        $this->dbforge->drop_column('settings', 'maintenance_mode');
        $this->dbforge->drop_column('settings', 'maintenance_message');
    }
}
