<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Migration_create_settings_table extends CI_Migration
{

    public function up()
    {
        $this->dbforge->add_field(array(
            'id' => array(
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ),
            'primary_color' => array(
                'type' => 'VARCHAR',
                'constraint' => '7',
                'default' => '#4e73df'
            ),
            'secondary_color' => array(
                'type' => 'VARCHAR',
                'constraint' => '7',
                'default' => '#1cc88a'
            ),
            'background_type' => array(
                'type' => 'VARCHAR',
                'constraint' => 20,
                'default' => 'gradient'
            ),
            'background_value' => array(
                'type' => 'TEXT',
                'null' => TRUE
            ),
            'background_overlay' => array(
                'type' => 'BOOLEAN',
                'default' => TRUE
            ),
            'created_at' => array(
                'type' => 'DATETIME',
                'null' => TRUE
            ),
            'updated_at' => array(
                'type' => 'DATETIME',
                'null' => TRUE
            )
        ));
        $this->dbforge->add_key('id', TRUE);
        $this->dbforge->create_table('settings');

        // Insert default settings
        $this->db->insert('settings', [
            'primary_color' => '#4e73df',
            'secondary_color' => '#1cc88a',
            'background_type' => 'gradient',
            'background_value' => 'linear-gradient(135deg, #667eea 0%, #764ba2 100%)',
            'background_overlay' => TRUE,
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        ]);
    }

    public function down()
    {
        $this->dbforge->drop_table('settings');
    }
}
