<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Create_password_resets_table extends CI_Migration
{

    public function up()
    {
        $this->dbforge->add_field(array(
            'id' => array(
                'type' => 'INT',
                'constraint' => 11,
                'auto_increment' => TRUE
            ),
            'email' => array(
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => FALSE
            ),
            'token' => array(
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => FALSE
            ),
            'expires_at' => array(
                'type' => 'DATETIME',
                'null' => FALSE
            ),
            'created_at' => array(
                'type' => 'TIMESTAMP',
                'default' => 'CURRENT_TIMESTAMP'
            )
        ));

        $this->dbforge->add_key('id', TRUE);
        $this->dbforge->add_key('token');
        $this->dbforge->add_key('email');
        $this->dbforge->create_table('password_resets');
    }

    public function down()
    {
        $this->dbforge->drop_table('password_resets');
    }
}
