<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_Add_password_reset_fields extends CI_Migration {

    public function up()
    {
        $fields = array(
            'reset_token' => array(
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => TRUE,
                'default' => NULL
            ),
            'reset_expires' => array(
                'type' => 'DATETIME',
                'null' => TRUE,
                'default' => NULL
            ),
            'reset_used' => array(
                'type' => 'BOOLEAN',
                'default' => FALSE
            )
        );
        
        $this->dbforge->add_column('users', $fields);
        
        // Add index for reset_token for better performance
        $this->db->query('CREATE INDEX idx_reset_token ON users(reset_token)');
    }

    public function down()
    {
        $this->dbforge->drop_column('users', 'reset_token');
        $this->dbforge->drop_column('users', 'reset_expires');
        $this->dbforge->drop_column('users', 'reset_used');
    }
}
