<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_Add_login_history_table extends CI_Migration {

    public function up()
    {
        $fields = [
            'id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE,
            ],
            'user_id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
            ],
            'login_time' => [
                'type' => 'DATETIME',
                'null' => FALSE,
            ],
            'ip_address' => [
                'type' => 'VARCHAR',
                'constraint' => '45',
                'null' => TRUE,
            ],
        ];

        $this->dbforge->add_field($fields);
        $this->dbforge->add_key('id', TRUE);
        $this->dbforge->create_table('login_history');
    }

    public function down()
    {
        $this->dbforge->drop_table('login_history');
    }
}
