<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_Add_missing_columns extends CI_Migration {

    public function up()
    {
        // Add source and source_type columns to videos table
        $fields = [
            'source' => [
                'type' => 'TEXT',
                'null' => TRUE,
            ],
            'source_type' => [
                'type' => 'VARCHAR',
                'constraint' => '50',
                'null' => TRUE,
            ],
        ];
        $this->dbforge->add_column('videos', $fields);
    }

    public function down()
    {
        // Drop the columns if rollback
        $this->dbforge->drop_column('videos', 'source');
        $this->dbforge->drop_column('videos', 'source_type');
    }
}
