<?php
defined('BASEPATH') or exit('No direct script access allowed');

class VideoService
{
    protected $CI;

    public function __construct()
    {
        // Get CodeIgniter instance
        $this->CI = &get_instance();
        $this->CI->load->model('Video_model');
    }

    public function createVideo($data)
    {
        return $this->CI->Video_model->upload_video($data);
    }

    public function getVideo($video_id)
    {
        return $this->CI->Video_model->get_video_by_id($video_id);
    }

    public function getAllVideos()
    {
        return $this->CI->Video_model->get_all_videos();
    }

    public function updateVideo($video_id, $data)
    {
        return $this->CI->Video_model->update_video($video_id, $data);
    }

    public function deleteVideo($video_id)
    {
        return $this->CI->Video_model->delete_video($video_id);
    }

    public function countVideos()
    {
        return $this->CI->Video_model->count_videos();
    }
}
