<?php
defined('BASEPATH') or exit('No direct script access allowed');

class TelegramService
{
    private $botToken;
    private $apiUrl;

    public function __construct()
    {
        // You can set the bot token here or pass it dynamically
        $this->botToken = '7661539861:AAFQvYnhYnGvDiG86oAn35pPVqB3og3-YEw';
        $this->apiUrl = "https://api.telegram.org/bot{$this->botToken}/";
    }

    /**
     * Get file info from Telegram API by file_id
     *
     * @param string $fileId
     * @return array|null
     */
    public function getFileInfo($fileId)
    {
        $url = $this->apiUrl . "getFile?file_id=" . urlencode($fileId);
        $response = $this->makeRequest($url);
        if ($response && isset($response['ok']) && $response['ok'] && isset($response['result'])) {
            return $response['result'];
        }
        return null;
    }

    /**
     * Get direct file download URL from Telegram file path
     *
     * @param string $filePath
     * @return string
     */
    public function getFileDownloadUrl($filePath)
    {
        return "https://api.telegram.org/file/bot{$this->botToken}/{$filePath}";
    }

    /**
     * Make HTTP GET request and decode JSON response
     *
     * @param string $url
     * @return array|null
     */
    private function makeRequest($url)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $result = curl_exec($ch);
        curl_close($ch);
        if ($result) {
            return json_decode($result, true);
        }
        return null;
    }

    /**
     * Extract direct video URL from Telegram message link
     * This requires the message link to contain chat_id and message_id
     *
     * @param string $telegramUrl
     * @return string|null Direct video URL or null if not found
     */
    public function extractDirectVideoUrl($telegramUrl)
    {
        // Example Telegram URL formats:
        // https://t.me/channelname/123
        // https://telegram.org/tv/channelname/123

        // Parse URL to extract chat and message id
        $parsed = parse_url($telegramUrl);
        if (!isset($parsed['path'])) {
            return null;
        }

        $pathParts = explode('/', trim($parsed['path'], '/'));
        if (count($pathParts) < 2) {
            return null;
        }

        $chat = $pathParts[count($pathParts) - 2];
        $messageId = $pathParts[count($pathParts) - 1];

        // Get chat_id from chat username (channelname)
        $chatId = $this->getChatIdByUsername($chat);
        if (!$chatId) {
            return null;
        }

        // Get message info
        $message = $this->getMessage($chatId, $messageId);
        if (!$message) {
            return null;
        }

        // Check if message has video or document with video mime type
        if (isset($message['video'])) {
            $fileId = $message['video']['file_id'];
        } elseif (isset($message['document']) && strpos($message['document']['mime_type'], 'video') === 0) {
            $fileId = $message['document']['file_id'];
        } else {
            return null;
        }

        // Get file info
        $fileInfo = $this->getFileInfo($fileId);
        if (!$fileInfo || !isset($fileInfo['file_path'])) {
            return null;
        }

        // Return direct download URL
        return $this->getFileDownloadUrl($fileInfo['file_path']);
    }

    /**
     * Get chat id by username using getChat method
     *
     * @param string $username
     * @return int|null
     */
    private function getChatIdByUsername($username)
    {
        $url = $this->apiUrl . "getChat?chat_id=" . urlencode('@' . $username);
        $response = $this->makeRequest($url);
        if ($response && isset($response['ok']) && $response['ok'] && isset($response['result']['id'])) {
            return $response['result']['id'];
        }
        return null;
    }

    /**
     * Get message by chat_id and message_id using getChatMember or getChatMessage (Telegram Bot API does not have getMessage, so this is a limitation)
     * Telegram Bot API does not provide a direct method to get arbitrary message content.
     * This method is a placeholder and will return null.
     *
     * @param int $chatId
     * @param int $messageId
     * @return array|null
     */
    private function getMessage($chatId, $messageId)
    {
        // Telegram Bot API does not support fetching arbitrary messages by ID.
        // This is a limitation. Alternative approaches:
        // - Use Telegram client API (MTProto) which is more complex.
        // - Require users to provide direct video file URLs.
        // For now, return null.
        return null;
    }
}
