<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Maintenance_hook
{
    protected $CI;

    public function __construct()
    {
        $this->CI = &get_instance();
        $this->CI->load->model('Settings_model');
        $this->CI->load->library('session');
        $this->CI->load->helper('url');
    }

    public function check_maintenance_mode()
    {
        $settings = $this->CI->Settings_model->get_settings();

        $maintenance_mode = $settings->maintenance_mode ?? 0;
        $current_controller = $this->CI->router->fetch_class();
        $current_method = $this->CI->router->fetch_method();

        // Allow access if maintenance mode is off
        if (!$maintenance_mode) {
            return;
        }

        // Allow access to admin, settings, auth, maintenance controllers
        $allowed_controllers = ['admin', 'settings', 'auth', 'maintenance'];

        // Allow access if user is admin
        $is_admin = $this->CI->session->userdata('role') === 'admin';

        if (in_array(strtolower($current_controller), $allowed_controllers) || $is_admin) {
            return;
        }

        // Allow access to ajax requests (optional)
        if ($this->CI->input->is_ajax_request()) {
            return;
        }

        // Redirect to maintenance page if not already there
        if ($current_controller !== 'maintenance') {
            redirect('maintenance');
            exit;
        }
    }
}
