<?php
defined('BASEPATH') or exit('No direct script access allowed');

class MY_Controller extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();

        // Load theme_helper globally for all controllers
        $this->load->helper('theme_helper');

        // Load database
        $this->load->database();

        // Ambil setting
        $setting = $this->db->get_where('settings', ['id' => 1])->row();

        if ($setting && $setting->maintenance_mode == 1) {
            // Cek apakah user sedang mengakses halaman admin
            if (strpos(uri_string(), 'admin') === false) {
                $this->showMaintenancePage($setting->maintenance_message);
                exit;
            }
        }
    }

    private function showMaintenancePage($message)
    {
        echo "<!DOCTYPE html>
        <html lang='id'>
        <head>
            <meta charset='UTF-8'>
            <meta name='viewport' content='width=device-width, initial-scale=1.0'>
            <title>Server Maintenance</title>
            <style>
                body {
                    display: flex; 
                    justify-content: center; 
                    align-items: center; 
                    height: 100vh; 
                    font-family: Arial, sans-serif; 
                    background: #f8f8f8; 
                    color: #333;
                    margin: 0;
                }
                .container {
                    text-align: center;
                    padding: 20px;
                    background: white;
                    border-radius: 8px;
                    box-shadow: 0 0 10px rgba(0,0,0,0.1);
                }
                h1 {
                    font-size: 24px;
                    margin-bottom: 10px;
                }
                p {
                    font-size: 16px;
                    color: #666;
                }
            </style>
        </head>
        <body>
            <div class='container'>
                <h1>🚧 Server Maintenance</h1>
                <p>{$message}</p>
            </div>
        </body>
        </html>";
    }
}
