<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Password_migration extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('User_model');
        $this->load->database();
    }

    /**
     * Migrate all user passwords to bcrypt hash.
     * This script assumes current passwords are stored in plain text or legacy hash.
     * It will reset passwords to a default value and hash them with bcrypt.
     * 
     * WARNING: This will reset all user passwords to 'defaultpassword123'.
     * Users should be notified to change their passwords after migration.
     */
    public function migrate_passwords()
    {
        $users = $this->User_model->get_all_users();
        $default_password = 'defaultpassword123';
        $hashed_password = password_hash($default_password, PASSWORD_DEFAULT);

        foreach ($users as $user) {
            // Update password to bcrypt hash of default password
            $update_data = ['password' => $hashed_password];
            $this->User_model->update_user($user->id, $update_data);
        }

        echo "Password migration completed. All passwords reset to '{$default_password}'. Please notify users to change their passwords.";
    }
}
