<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Auth extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('User_model');
        $this->load->model('Login_history_model');
        $this->load->library(['form_validation', 'session']);
    }

    public function login()
    {
        // Redirect if already logged in
        $role = $this->session->userdata('role');
        if ($role === 'admin') {
            redirect('admin/dashboard');
        } elseif ($role === 'user') {
            redirect('dashboard');
        }

        $this->form_validation->set_rules('email', 'Email', 'required|valid_email');
        $this->form_validation->set_rules('password', 'Password', 'required');

        if ($this->form_validation->run() === FALSE) {
            $this->load->view('auth/login');
        } else {
            $email = $this->input->post('email');
            $password = $this->input->post('password');
            $user = $this->User_model->get_user_by_email($email);

            if ($user && password_verify($password, $user->password)) {
                // Insert login history record
                $ip_address = $this->input->ip_address();
                $this->Login_history_model->insert_login($user->id, $ip_address);

                if ($user->role == 'admin') {
                    $this->session->set_userdata([
                        'user_id' => $user->id,
                        'email' => $user->email,
                        'role' => $user->role,
                        'profile_photo' => $user->profile_photo ?? null
                    ]);
                    redirect('admin/dashboard');
                } elseif ($user->role == 'user') {
                    $this->session->set_userdata([
                        'user_id' => $user->id,
                        'email' => $user->email,
                        'role' => $user->role,
                        'profile_photo' => $user->profile_photo ?? null
                    ]);
                    redirect('dashboard');
                } else {
                    $this->session->set_flashdata('error', 'Role tidak dikenali!');
                    redirect('auth/login');
                }
            } else {
                $this->session->set_flashdata('error', 'Email atau password salah!');
                redirect('auth/login');
            }
        }
    }

    public function register()
    {
        $this->form_validation->set_rules('email', 'Email', 'required|valid_email|is_unique[users.email]');
        $this->form_validation->set_rules('password', 'Password', 'required|min_length[6]');
        $this->form_validation->set_rules('confirm_password', 'Konfirmasi Password', 'required|matches[password]');

        if ($this->form_validation->run() == FALSE) {
            $this->load->view('auth/register');
        } else {
            $email = $this->input->post('email', true);
            $password = password_hash($this->input->post('password'), PASSWORD_DEFAULT);

            $data = [
                'email' => $email,
                'password' => $password,
                'role' => 'admin', // Bisa disesuaikan nanti
            ];

            $this->User_model->insert_user($data);
            $this->session->set_flashdata('success', 'Registrasi berhasil. Silakan login.');
            redirect('auth/login');
        }
    }

    public function logout()
    {
        // Update logout time in login_history
        $user_id = $this->session->userdata('user_id');
        if ($user_id) {
            $this->Login_history_model->update_logout($user_id);
        }

        $this->session->sess_destroy();
        redirect('auth/login');
    }
}
