<?php
defined('BASEPATH') or exit('No direct script access allowed');

// Default Controller (login page sebagai landing page)
$route['default_controller'] = 'auth/login';

// Auth Routes
$route['login'] = 'auth/login';
$route['register'] = 'auth/register';
$route['logout'] = 'auth/logout';

// User Dashboard & Video Routes
$route['dashboard'] = 'user/dashboard';
$route['upload-video'] = 'user/upload_video';
$route['live-video'] = 'user/live_video';
$route['list-video'] = 'user/list_video';
$route['upload-video'] = 'user/upload_video';
$route['myvideo'] = 'user/myvideo';

$route['myprofile'] = 'user/profile';
$route['user/edit_profile'] = 'user/edit_profile';
$route['user/delete_account'] = 'user/delete_account';
$route['user/forgot_password'] = 'user/forgot_password';
$route['user/contact_admin'] = 'user/contact_admin';
$route['user/theme'] = 'user/theme';

// Admin Panel
$route['admin/dashboard'] = 'admin/dashboard';
$route['admin/live-video'] = 'admin/live_video';
$route['admin/upload-video'] = 'admin/upload_video';
$route['admin/list-video'] = 'admin/list_video';
$route['admin/users'] = 'admin/manage_users';

$route['admin/edit_user/(:num)'] = 'admin/edit_user/$1';
$route['admin/delete_user/(:num)'] = 'admin/delete_user/$1';
$route['admin/edit_video/(:num)'] = 'admin/edit_video/$1';
$route['admin/delete_video/(:num)'] = 'admin/delete_video/$1';

// 404 & URI Translation
$route['theme'] = 'settings/theme';
$route['settings/theme'] = 'settings/theme';
$route['watch-video/(:num)'] = 'user/watch_video/$1';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;

// Password reset routes
$route['user/reset-password/(:any)'] = 'user/reset_password/$1';
$route['user/reset-password'] = 'user/reset_password';
$route['user/update-password'] = 'user/update_password';

$route['mobile-simple-video/(:num)'] = 'user/mobile_simple_video/$1';
